/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.dialogs;

import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.dialogs.ErrorDialog;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.util.DownloadThread;
import edu.colorado.phet.common.phetcommon.view.MaxCharsLabel;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class DownloadProgressDialog
extends PaintImmediateDialog {
    private final DownloadThread downloadThread;
    private final DownloadThread.DownloadThreadListener downloadThreadListener;
    private final JProgressBar progressBar;
    private final MaxCharsLabel statusLabel;

    public DownloadProgressDialog(Frame frame, String string, String string2, DownloadThread downloadThread) {
        super(frame, string);
        this.setModal(true);
        this.setResizable(false);
        this.downloadThread = downloadThread;
        this.downloadThreadListener = new ThisDownloadThreadListener();
        this.downloadThread.addListener(this.downloadThreadListener);
        JLabel jLabel = new JLabel(string2);
        this.progressBar = new JProgressBar(0, 100);
        this.statusLabel = new MaxCharsLabel(50, 25);
        this.statusLabel.setFont(new PhetFont(10));
        JButton jButton = new JButton(PhetCommonResources.getString("Common.choice.cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DownloadProgressDialog.this.doCancel();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DownloadProgressDialog.this.doCancel();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel);
        easyGridBagLayout.setMinimumWidth(0, 400);
        jPanel.setLayout(easyGridBagLayout);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.setInsets(new Insets(10, 5, 10, 5));
        easyGridBagLayout.addComponent(jLabel, n++, n2);
        easyGridBagLayout.setInsets(new Insets(5, 5, 5, 5));
        easyGridBagLayout.addFilledComponent(this.progressBar, n++, n2, 2);
        easyGridBagLayout.addComponent(this.statusLabel, n++, n2);
        easyGridBagLayout.addFilledComponent(new JSeparator(), n++, n2, 2);
        easyGridBagLayout.setInsets(new Insets(5, 5, 10, 5));
        easyGridBagLayout.addAnchoredComponent(jButton, n, n2, 10);
        this.getContentPane().add(jPanel);
        this.pack();
        SwingUtils.centerDialog(this, frame);
    }

    private void doCancel() {
        this.downloadThread.cancel();
    }

    public void dispose() {
        this.downloadThread.removeListener(this.downloadThreadListener);
        super.dispose();
    }

    private class ThisDownloadThreadListener
    implements DownloadThread.DownloadThreadListener {
        private ThisDownloadThreadListener() {
        }

        public void succeeded() {
            this.disposeProgressDialog();
        }

        public void failed() {
        }

        public void canceled() {
            this.disposeProgressDialog();
        }

        public void requestAdded(String string, String string2, File file) {
        }

        public void progress(final String string, String string2, File file, double d, final double d2) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DownloadProgressDialog.this.statusLabel.setText(string);
                    DownloadProgressDialog.this.progressBar.setValue((int)(d2 * (double)(DownloadProgressDialog.this.progressBar.getMaximum() - DownloadProgressDialog.this.progressBar.getMinimum())));
                }
            });
        }

        public void completed(String string, String string2, File file) {
        }

        public void error(String string, String string2, File file, final String string3, final Exception exception) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ErrorDialog errorDialog = new ErrorDialog(DownloadProgressDialog.this, string3, exception);
                    errorDialog.setVisible(true);
                }
            });
            this.disposeProgressDialog();
        }

        private void disposeProgressDialog() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DownloadProgressDialog.this.dispose();
                }
            });
        }
    }
}

