/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.updates.dialogs;

import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.resources.PhetInstallerVersion;
import edu.colorado.phet.common.phetcommon.servicemanager.PhetServiceManager;
import edu.colorado.phet.common.phetcommon.updates.IAskMeLaterStrategy;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public abstract class InstallerAbstractUpdateDialog
extends PaintImmediateDialog {
    private static final String TITLE = PhetCommonResources.getString("Common.updates.updateAvailable");
    private static final String UPDATE_BUTTON = PhetCommonResources.getString("Common.updates.installer.yes");
    private static final String ASK_ME_LATER_BUTTON = PhetCommonResources.getString("Common.updates.askMeLater");
    private static final String MORE_BUTTON = PhetCommonResources.getString("Common.updates.installer.more");
    private static final String NO_BUTTON = PhetCommonResources.getString("Common.choice.no");
    private static final String MESSAGE_PATTERN = PhetCommonResources.getString("Common.updates.installer.message");
    private static final String MORE_MESSAGE = PhetCommonResources.getString("Common.updates.installer.moreMessage");

    public InstallerAbstractUpdateDialog(Frame frame) {
        super(frame, TITLE);
        this.setModal(true);
        this.setResizable(false);
    }

    protected void initGUI(PhetInstallerVersion phetInstallerVersion, PhetInstallerVersion phetInstallerVersion2) {
        JPanel jPanel = this.createMessagePanel(phetInstallerVersion, phetInstallerVersion2);
        JPanel jPanel2 = this.createButtonPanel();
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(new EmptyBorder(5, 5, 5, 5));
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel3);
        jPanel3.setLayout(easyGridBagLayout);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(jPanel, n++, n2);
        easyGridBagLayout.addFilledComponent(new JSeparator(), n++, n2, 2);
        easyGridBagLayout.addAnchoredComponent(jPanel2, n++, n2, 10);
        this.setContentPane(jPanel3);
        this.pack();
        SwingUtils.centerDialogInParent(this);
    }

    private JPanel createMessagePanel(PhetInstallerVersion phetInstallerVersion, PhetInstallerVersion phetInstallerVersion2) {
        String string = phetInstallerVersion.formatTimestamp();
        String string2 = phetInstallerVersion2.formatTimestamp();
        Object[] objectArray = new Object[]{string, string2};
        String string3 = MessageFormat.format(MESSAGE_PATTERN, objectArray);
        JLabel jLabel = new JLabel(string3);
        JPanel jPanel = new JPanel();
        jPanel.add(jLabel);
        return jPanel;
    }

    protected abstract JPanel createButtonPanel();

    protected static class MoreButton
    extends JButton {
        public MoreButton(final JDialog jDialog) {
            super(MORE_BUTTON);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PhetOptionPane.showMessageDialog(jDialog, MORE_MESSAGE, TITLE);
                }
            });
        }
    }

    protected static class NoButton
    extends JButton {
        public NoButton(final JDialog jDialog) {
            super(NO_BUTTON);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jDialog.dispose();
                }
            });
        }
    }

    protected static class AskMeLaterButton
    extends JButton {
        public AskMeLaterButton(final JDialog jDialog, final IAskMeLaterStrategy iAskMeLaterStrategy) {
            super(ASK_ME_LATER_BUTTON);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    iAskMeLaterStrategy.setStartTime(System.currentTimeMillis());
                    jDialog.dispose();
                }
            });
        }
    }

    protected static class UpdateButton
    extends JButton {
        public UpdateButton(final JDialog jDialog) {
            super(UPDATE_BUTTON);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PhetServiceManager.showWebPage("http://phet.colorado.edu/get_phet/full_install.php");
                    jDialog.dispose();
                }
            });
        }
    }
}

