/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.event;

import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.util.ArrayList;

public class ButtonEventHandler
extends PBasicInputEventHandler {
    private boolean mousePressed = false;
    private boolean mouseInside = false;
    private ArrayList listeners = new ArrayList();

    public void mouseEntered(PInputEvent pInputEvent) {
        this.mouseInside = true;
        this.notifyFocus(true);
        if (this.mousePressed) {
            this.notifyArmed(true);
        }
    }

    public void mouseExited(PInputEvent pInputEvent) {
        this.mouseInside = false;
        this.notifyFocus(false);
        if (this.mousePressed) {
            this.notifyArmed(false);
        }
    }

    public void mousePressed(PInputEvent pInputEvent) {
        this.mousePressed = true;
        this.notifyArmed(true);
    }

    public void mouseReleased(PInputEvent pInputEvent) {
        this.mousePressed = false;
        this.notifyArmed(false);
        if (this.mouseInside) {
            this.notifyFire();
        }
    }

    public void addButtonEventListener(ButtonEventListener buttonEventListener) {
        this.listeners.add(buttonEventListener);
    }

    private void notifyFocus(boolean bl) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ButtonEventListener)this.listeners.get(i)).setFocus(bl);
        }
    }

    private void notifyArmed(boolean bl) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ButtonEventListener)this.listeners.get(i)).setArmed(bl);
        }
    }

    private void notifyFire() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ButtonEventListener)this.listeners.get(i)).fire();
        }
    }

    public static class ButtonEventAdapter
    implements ButtonEventListener {
        public void setFocus(boolean bl) {
        }

        public void setArmed(boolean bl) {
        }

        public void fire() {
        }
    }

    public static interface ButtonEventListener {
        public void setFocus(boolean var1);

        public void setArmed(boolean var1);

        public void fire();
    }
}

