/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.motionseries.model;

import edu.colorado.phet.motionseries.MotionSeriesResources$;
import edu.colorado.phet.motionseries.model.MotionSeriesObjectTypeState;
import edu.colorado.phet.motionseries.sims.rampforcesandmotionbasics.RampForcesAndMotionBasicsSettings$;
import java.awt.image.BufferedImage;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.runtime.BoxesRunTime;

public class MotionSeriesObjectType {
    private double _mass;
    private double _kineticFriction;
    private double _staticFriction;
    private final double _height;
    private final String _crashImageFilename;
    private final String iconFilename;
    private final int points;
    private final boolean customizable;
    private final String name;
    private final String imageFilename;
    private final BufferedImage bufferedImage;
    private final BufferedImage iconImage;

    public double _mass() {
        return this._mass;
    }

    public double _kineticFriction() {
        return this._kineticFriction;
    }

    public void _kineticFriction_$eq(double d) {
        this._kineticFriction = d;
    }

    public double _staticFriction() {
        return this._staticFriction;
    }

    public void _staticFriction_$eq(double d) {
        this._staticFriction = d;
    }

    public String iconFilename() {
        return this.iconFilename;
    }

    public int points() {
        return this.points;
    }

    public boolean customizable() {
        return this.customizable;
    }

    public String name() {
        return this.name;
    }

    public String crashImageFilename() {
        return this._crashImageFilename;
    }

    public MotionSeriesObjectTypeState state() {
        return new MotionSeriesObjectTypeState(this.name(), this.mass(), this.kineticFriction(), this.staticFriction(), this.height(), this.imageFilename(), this.crashImageFilename(), this.iconFilename(), this.customizable(), this.points(), (Function1<MotionSeriesObjectTypeState, MotionSeriesObjectType>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final MotionSeriesObjectType $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final MotionSeriesObjectType apply(MotionSeriesObjectTypeState motionSeriesObjectTypeState) {
                return this.$outer.createFactory(motionSeriesObjectTypeState);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
    }

    public MotionSeriesObjectType createFactory(MotionSeriesObjectTypeState state2) {
        return new MotionSeriesObjectType(state2.name(), state2.mass(), state2.kinFric(), state2.statFric(), state2.height(), state2.imageFilename(), state2.crashImageFilename(), state2.iconFilename(), state2.customizable(), state2.points());
    }

    public double kineticFriction() {
        return this._kineticFriction();
    }

    public double staticFriction() {
        return this._staticFriction();
    }

    public double mass() {
        return this._mass();
    }

    public String imageFilename() {
        return this.imageFilename;
    }

    public String getDisplayText() {
        return MotionSeriesResources$.MODULE$.toMyRichString("object.description.pattern.name_mass").messageformat(Predef$.MODULE$.wrapRefArray(new Object[]{this.name(), ((Object)BoxesRunTime.boxToDouble(this.mass())).toString()}));
    }

    public String getDisplayTextHTML() {
        return MotionSeriesResources$.MODULE$.toMyRichString("object.description.combobox.html.pattern.name_mass_kinetic_static").messageformat(Predef$.MODULE$.wrapRefArray(new Object[]{this.name(), ((Object)BoxesRunTime.boxToInteger((int)this.mass())).toString(), ((Object)BoxesRunTime.boxToDouble(this.kineticFriction())).toString(), ((Object)BoxesRunTime.boxToDouble(this.staticFriction())).toString()}));
    }

    public double height() {
        return this._height;
    }

    public BufferedImage bufferedImage() {
        return this.bufferedImage;
    }

    public BufferedImage iconImage() {
        return this.iconImage;
    }

    public double width() {
        return (double)this.bufferedImage().getWidth() * this.height() / (double)this.bufferedImage().getHeight();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        MotionSeriesObjectType motionSeriesObjectType;
        Object object = obj;
        if (!(object instanceof MotionSeriesObjectType)) return false;
        MotionSeriesObjectType a = motionSeriesObjectType = (MotionSeriesObjectType)object;
        String string = a.name();
        String string2 = this.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (a.mass() != this.mass()) return false;
        if (a.height() != this.height()) return false;
        if (a.kineticFriction() != this.kineticFriction()) return false;
        return true;
    }

    public int hashCode() {
        return ((Object)BoxesRunTime.boxToDouble(this.mass())).hashCode() + this.name().hashCode() * 17;
    }

    public MotionSeriesObjectType(String _name, double _mass, double _kineticFriction, double _staticFriction, double _height, String _imageFilename, String _crashImageFilename, String iconFilename, boolean _customizable, int points) {
        this._mass = _mass;
        this._kineticFriction = _kineticFriction;
        this._staticFriction = _staticFriction;
        this._height = _height;
        this._crashImageFilename = _crashImageFilename;
        this.iconFilename = iconFilename;
        this.points = points;
        this.customizable = _customizable;
        this.name = _name;
        this.imageFilename = _imageFilename;
        this.bufferedImage = MotionSeriesResources$.MODULE$.getImage(this.imageFilename());
        this.iconImage = MotionSeriesResources$.MODULE$.getImage(iconFilename);
        if (RampForcesAndMotionBasicsSettings$.MODULE$.basics()) {
            this._kineticFriction_$eq(0.5);
            this._staticFriction_$eq(0.5);
        }
    }

    public MotionSeriesObjectType(String name, double mass, double kineticFriction, double staticFriction, double height, String imageFilename, String crashImageFilename, int points) {
        this(name, mass, kineticFriction, staticFriction, height, imageFilename, crashImageFilename, imageFilename, false, points);
    }

    public MotionSeriesObjectType(String name, double mass, double kineticFriction, double staticFriction, double height, String imageFilename, int points) {
        this(name, mass, kineticFriction, staticFriction, height, imageFilename, imageFilename, imageFilename, false, points);
    }
}

