/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.charts;

import edu.colorado.phet.common.motion.model.TimeData;
import java.util.ArrayList;

public class TemporalDataSeries {
    private ArrayList<TimeData> data = new ArrayList();
    private ArrayList<Listener> listeners = new ArrayList();
    private boolean visible = true;

    public TimeData[] getData() {
        return this.data.toArray(new TimeData[this.data.size()]);
    }

    public void addPoint(double d, double d2) {
        this.addPoint(new TimeData(d, d2));
    }

    public void addPoint(TimeData timeData) {
        this.data.add(timeData);
        for (Listener listener : this.listeners) {
            listener.dataPointAdded(timeData);
        }
    }

    private void notifyEntrireSeriesChanged() {
        for (Listener listener : this.listeners) {
            listener.entireSeriesChanged();
        }
    }

    public void clear() {
        this.data.clear();
        this.notifyEntrireSeriesChanged();
    }

    public void clearPointsAfter(double d) {
        ArrayList<TimeData> arrayList = new ArrayList<TimeData>();
        for (TimeData timeData : this.data) {
            if (!(timeData.getTime() < d)) continue;
            arrayList.add(timeData);
        }
        this.data.clear();
        this.data.addAll(arrayList);
        this.notifyEntrireSeriesChanged();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(Boolean bl) {
        this.visible = bl;
        for (Listener listener : this.listeners) {
            listener.visibilityChanged();
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public static class Adapter
    implements Listener {
        public void entireSeriesChanged() {
        }

        public void dataPointAdded(TimeData timeData) {
        }

        public void visibilityChanged() {
        }
    }

    public static interface Listener {
        public void entireSeriesChanged();

        public void dataPointAdded(TimeData var1);

        public void visibilityChanged();
    }
}

