/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.simsharing;

import java.util.HashMap;

public class SimSharingConfig {
    public static final SimSharingConfig INTERVIEWS = new SimSharingConfig("interviews", true, false, false, false);
    public static final SimSharingConfig COLORADO_CONFIG = new SimSharingConfig("colorado", false, true, true, true, "Enter your computer number:");
    public static final SimSharingConfig UTAH_CONFIG = new SimSharingConfig("utah", false, true, true, false, "Enter your audio recorder number:");
    public static final SimSharingConfig DALLAS_JAN_2012 = new SimSharingConfig("dallas-jan-2012", true, true, false, false);
    public static final SimSharingConfig DALLAS_JAN_2012_ID = new SimSharingConfig("dallas-jan-2012-id", true, true, false, false);
    public static final SimSharingConfig ABS_SPRING_2012 = new SimSharingConfig("acid-base-solutions-spring-2012", true, true, false, false);
    public static final SimSharingConfig FARADAY_SPRING_2012 = new SimSharingConfig("faraday-spring-2012", false, true, false, false);
    public static final SimSharingConfig BALANCING_ACT_SPRING_2012 = new SimSharingConfig("balancing-act-spring-2012", true, true, true, true, "Please enter ID:");
    public static final SimSharingConfig MOLECULE_SHAPED_FEB_2012 = new SimSharingConfig("molecule-shapes-feb-2012", true, true, false, false);
    public static final SimSharingConfig LOAD_TESTING = new SimSharingConfig("load-testing", false, true, false, false);
    public static final SimSharingConfig DEFAULT = new SimSharingConfig("default", false, false, false, false, "");
    public static final SimSharingConfig RPAL_APRIL_2012 = new SimSharingConfig("rpal-april-2012", true, false, false, false);
    private static final HashMap<String, SimSharingConfig> CONFIG_MAP = new HashMap();
    public final String studyName;
    public final boolean requestId;
    public final boolean idRequired;
    public final String idPrompt;
    public final boolean sendToLogFile;
    public final boolean sendToServer;
    public final boolean collectIPAddress = false;

    private static void addConfig(SimSharingConfig simSharingConfig) {
        assert (CONFIG_MAP.get(simSharingConfig.studyName) == null);
        CONFIG_MAP.put(simSharingConfig.studyName, simSharingConfig);
    }

    public static SimSharingConfig getConfig(String string) {
        SimSharingConfig simSharingConfig = CONFIG_MAP.get(string);
        if (simSharingConfig == null) {
            simSharingConfig = DEFAULT;
        }
        return simSharingConfig;
    }

    protected SimSharingConfig(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(string, bl, bl2, bl3, bl4, null);
    }

    protected SimSharingConfig(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string2) {
        this.studyName = string;
        this.sendToLogFile = bl;
        this.sendToServer = bl2;
        this.requestId = bl3;
        this.idPrompt = string2;
        this.idRequired = bl4;
    }

    static {
        SimSharingConfig.addConfig(INTERVIEWS);
        SimSharingConfig.addConfig(COLORADO_CONFIG);
        SimSharingConfig.addConfig(UTAH_CONFIG);
        SimSharingConfig.addConfig(DALLAS_JAN_2012);
        SimSharingConfig.addConfig(DALLAS_JAN_2012_ID);
        SimSharingConfig.addConfig(ABS_SPRING_2012);
        SimSharingConfig.addConfig(FARADAY_SPRING_2012);
        SimSharingConfig.addConfig(BALANCING_ACT_SPRING_2012);
        SimSharingConfig.addConfig(MOLECULE_SHAPED_FEB_2012);
        SimSharingConfig.addConfig(LOAD_TESTING);
        SimSharingConfig.addConfig(RPAL_APRIL_2012);
    }
}

