/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.motionseries.javastage.stage;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.motionseries.javastage.stage.Stage;
import edu.colorado.phet.motionseries.javastage.stage.StageContainer;
import edu.umd.cs.piccolo.PNode;
import java.awt.geom.Rectangle2D;

public class StageNode
extends PNode {
    private final Stage stage;
    private final StageContainer stageContainer;
    private PNode node;

    public StageNode(Stage stage, StageContainer stageContainer, PNode pNode) {
        if (stage == null) {
            throw new IllegalArgumentException("Stage was null");
        }
        if (stageContainer == null) {
            throw new IllegalArgumentException("Stage container was null");
        }
        if (pNode == null) {
            throw new IllegalArgumentException("node was null");
        }
        this.stage = stage;
        this.stageContainer = stageContainer;
        this.node = pNode;
        this.addChild(pNode);
        stageContainer.addContainerBoundsChangeListener(new StageContainer.Listener(){

            public void stageContainerBoundsChanged() {
                StageNode.this.updateLayout();
            }
        });
        stage.addObserver(new SimpleObserver(){

            public void update() {
                StageNode.this.updateLayout();
            }
        });
        this.updateLayout();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StageNode stageNode = (StageNode)object;
        if (this.node != stageNode.node) {
            return false;
        }
        if (this.stage != stageNode.stage) {
            return false;
        }
        return this.stageContainer == stageNode.stageContainer;
    }

    protected void updateLayout() {
        Rectangle2D rectangle2D = this.stageContainer.getContainerBounds();
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        if (d3 > 0.0 && d4 > 0.0) {
            double d5;
            double d6 = d3 / this.stage.getWidth();
            double d7 = Math.min(d6, d5 = d4 / this.stage.getHeight());
            double d8 = d7 > 0.0 ? d7 : 1.0;
            this.setScale(d8);
            double d9 = d8 * this.stage.getWidth();
            double d10 = d8 * this.stage.getHeight();
            this.setOffset(d3 / 2.0 - d9 / 2.0 + d, d4 / 2.0 - d10 / 2.0 + d2);
        }
    }
}

