/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import java.util.Map;

public class WriteConcern {
    public static final WriteConcern NONE = new WriteConcern(-1);
    public static final WriteConcern NORMAL = new WriteConcern(0);
    public static final WriteConcern SAFE = new WriteConcern(1);
    public static final WriteConcern MAJORITY = new Majority();
    public static final WriteConcern FSYNC_SAFE = new WriteConcern(true);
    public static final WriteConcern JOURNAL_SAFE = new WriteConcern(1, 0, false, true);
    public static final WriteConcern REPLICAS_SAFE = new WriteConcern(2);
    private static Map<String, WriteConcern> _namedConcerns = null;
    Object _w = 0;
    int _wtimeout = 0;
    boolean _fsync = false;
    boolean _j = false;
    boolean _continueOnErrorForInsert = false;

    public WriteConcern() {
        this(0);
    }

    public WriteConcern(int w) {
        this(w, 0, false);
    }

    public WriteConcern(boolean fsync) {
        this(1, 0, fsync);
    }

    public WriteConcern(int w, int wtimeout, boolean fsync) {
        this(w, wtimeout, fsync, false);
    }

    public WriteConcern(int w, int wtimeout, boolean fsync, boolean j) {
        this(w, wtimeout, fsync, j, false);
    }

    public WriteConcern(int w, int wtimeout, boolean fsync, boolean j, boolean continueOnInsertError) {
        this._w = w;
        this._wtimeout = wtimeout;
        this._fsync = fsync;
        this._j = j;
        this._continueOnErrorForInsert = continueOnInsertError;
    }

    public WriteConcern(String w, int wtimeout, boolean fsync, boolean j) {
        this(w, wtimeout, fsync, j, false);
    }

    public WriteConcern(String w, int wtimeout, boolean fsync, boolean j, boolean continueOnInsertError) {
        this._w = w;
        this._wtimeout = wtimeout;
        this._fsync = fsync;
        this._j = j;
        this._continueOnErrorForInsert = continueOnInsertError;
    }

    public BasicDBObject getCommand() {
        BasicDBObject _command = new BasicDBObject("getlasterror", (Object)1);
        if (this._w instanceof Integer && (Integer)this._w > 0 || this._w instanceof String && this._w != null) {
            _command.put("w", this._w);
            _command.put("wtimeout", (Object)this._wtimeout);
        }
        if (this._fsync) {
            _command.put("fsync", (Object)true);
        }
        if (this._j) {
            _command.put("j", (Object)true);
        }
        return _command;
    }

    public boolean raiseNetworkErrors() {
        if (this._w instanceof Integer) {
            return (Integer)this._w >= 0;
        }
        return this._w != null;
    }

    public boolean callGetLastError() {
        if (this._w instanceof Integer) {
            return (Integer)this._w > 0;
        }
        return this._w != null;
    }

    public String toString() {
        return "WriteConcern " + this.getCommand() + " / (Continue Inserting on Errors? " + this.getContinueOnErrorForInsert() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteConcern that = (WriteConcern)o;
        return this._fsync == that._fsync && this._w == that._w && this._wtimeout == that._wtimeout && this._j == that._j && this._continueOnErrorForInsert == that._continueOnErrorForInsert;
    }

    public boolean getContinueOnErrorForInsert() {
        return this._continueOnErrorForInsert;
    }

    public static class Majority
    extends WriteConcern {
        public Majority() {
            super("majority", 0, false, false);
        }

        public String toString() {
            return "[Majority] WriteConcern " + this.getCommand();
        }
    }
}

