/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.graphics;

import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class TriColorRoundGradientPaint
implements Paint {
    private final Color innerColor;
    private final Color middleColor;
    private final Color outerColor;
    private final Point2D center;
    private final double innerMiddleSpan;
    private final double middleOuterSpan;

    public TriColorRoundGradientPaint(Color color, Color color2, Color color3, double d, double d2, double d3, double d4) {
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("innerMiddleSpan must be > 0.");
        }
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("middleOuterSpan must be > 0.");
        }
        this.middleColor = color2;
        this.innerColor = color;
        this.outerColor = color3;
        this.center = new Point2D.Double(d, d2);
        this.innerMiddleSpan = d3;
        this.middleOuterSpan = d4;
    }

    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        Point2D point2D = affineTransform.transform(this.center, null);
        double d = affineTransform.deltaTransform(new Point2D.Double(this.innerMiddleSpan, 0.0), null).getX();
        double d2 = affineTransform.deltaTransform(new Point2D.Double(this.middleOuterSpan, 0.0), null).getX();
        return new TriColorRoundGradientContext(this.innerColor, this.middleColor, this.outerColor, point2D, d, d2);
    }

    public int getTransparency() {
        int n;
        int n2 = this.innerColor.getAlpha();
        return (n2 & (n = this.middleColor.getAlpha())) == 255 ? 1 : 3;
    }

    private static class TriColorRoundGradientContext
    implements PaintContext {
        private final Color innerColor;
        private final Color middleColor;
        private final Color outerColor;
        private final Point2D center;
        private final double innerMiddleSpan;
        private final double middleOuterSpan;
        private WritableRaster raster;

        public TriColorRoundGradientContext(Color color, Color color2, Color color3, Point2D point2D, double d, double d2) {
            assert (d >= 0.0);
            assert (d2 >= 0.0);
            this.innerMiddleSpan = d;
            this.middleOuterSpan = d2;
            this.innerColor = color;
            this.middleColor = color2;
            this.outerColor = color3;
            this.center = point2D;
        }

        public void dispose() {
        }

        public ColorModel getColorModel() {
            return ColorModel.getRGBdefault();
        }

        public Raster getRaster(int n, int n2, int n3, int n4) {
            if (this.raster == null || n3 > this.raster.getWidth() || n4 > this.raster.getHeight()) {
                this.raster = this.getColorModel().createCompatibleWritableRaster(n3, n4);
            }
            TriColorRoundGradientContext.paint(n, n2, n3, n4, this.raster, this.innerColor, this.middleColor, this.outerColor, this.center, this.innerMiddleSpan, this.middleOuterSpan);
            return this.raster;
        }

        private static void paint(int n, int n2, int n3, int n4, WritableRaster writableRaster, Color color, Color color2, Color color3, Point2D point2D, double d, double d2) {
            int[] nArray = new int[n3 * n4 * 4];
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    double d3;
                    Color color4;
                    Color color5;
                    double d4 = point2D.distance(n + j, n2 + i);
                    if (d4 <= d) {
                        color5 = color;
                        color4 = color2;
                        d3 = d4 / d;
                    } else {
                        color5 = color2;
                        color4 = color3;
                        d3 = (d4 - d) / d2;
                        if (d3 > 1.0) {
                            d3 = 1.0;
                        }
                    }
                    int n5 = (i * n3 + j) * 4;
                    nArray[n5 + 0] = TriColorRoundGradientContext.interpolateColorComponent(color5.getRed(), color4.getRed(), d3);
                    nArray[n5 + 1] = TriColorRoundGradientContext.interpolateColorComponent(color5.getGreen(), color4.getGreen(), d3);
                    nArray[n5 + 2] = TriColorRoundGradientContext.interpolateColorComponent(color5.getBlue(), color4.getBlue(), d3);
                    nArray[n5 + 3] = TriColorRoundGradientContext.interpolateColorComponent(color5.getAlpha(), color4.getAlpha(), d3);
                }
            }
            writableRaster.setPixels(0, 0, n3, n4, nArray);
        }

        private static int interpolateColorComponent(int n, int n2, double d) {
            assert (n >= 0 && n <= 255);
            assert (n2 >= 0 && n2 <= 255);
            assert (d >= 0.0 && d <= 1.0);
            return (int)((double)n + d * (double)(n2 - n));
        }
    }
}

