/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.graphics.transforms;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class ModelViewTransform {
    private AffineTransform transform;

    private ModelViewTransform(AffineTransform affineTransform) {
        this.transform = affineTransform;
    }

    public static ModelViewTransform createIdentity() {
        return new ModelViewTransform(new AffineTransform());
    }

    public Point2D modelToView(Point2D point2D) {
        return this.transform.transform(point2D, null);
    }

    public Shape modelToView(Shape shape) {
        return this.transform.createTransformedShape(shape);
    }

    public double modelToViewY(double d) {
        return this.modelToView(0.0, d).getY();
    }

    public Point2D modelToView(double d, double d2) {
        return this.modelToView(new Point2D.Double(d, d2));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return this.transform.equals(((ModelViewTransform)object).transform);
    }

    public int hashCode() {
        return this.transform.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.transform.toString();
    }
}

