/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forcesandmotionbasics.common;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.ArrowNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPText;
import edu.colorado.phet.forcesandmotionbasics.ForcesAndMotionBasicsResources;
import edu.colorado.phet.forcesandmotionbasics.common.AbstractForcesAndMotionBasicsCanvas;
import edu.colorado.phet.forcesandmotionbasics.common.TextLocation;
import edu.umd.cs.piccolo.PNode;
import fj.data.Option;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.text.MessageFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForceArrowNode
extends PNode {
    private final double forceInNewtons;
    private PhetPText nameNode;

    public ForceArrowNode(boolean bl, Vector2D vector2D, double d, String string, Color color, TextLocation textLocation, boolean bl2) {
        this(bl, vector2D, d, string, color, textLocation, bl2, Option.none());
    }

    public ForceArrowNode(boolean bl, Vector2D vector2D, final double d, String string, Color color, final TextLocation textLocation, boolean bl2, Option<ForceArrowNode> option) {
        this.forceInNewtons = d;
        final double d2 = d * 3.5 / 5.0;
        if (d2 == 0.0 && textLocation == TextLocation.SIDE) {
            return;
        }
        if (d2 == 0.0 && textLocation == TextLocation.TOP) {
            this.showTextOnly(vector2D);
            return;
        }
        Point2D.Double double_ = vector2D.plus(d2, 0.0).toPoint2D();
        final ArrowNode arrowNode = new ArrowNode(vector2D.toPoint2D(), double_, 36.0, 48.0, 24.0, 0.5, false);
        arrowNode.setPaint(bl ? new Color(color.getRed(), color.getGreen(), color.getBlue(), 175) : color);
        arrowNode.setStroke(bl ? new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{6.0f, 4.0f}, 0.0f) : new BasicStroke(1.0f));
        this.addChild(arrowNode);
        this.nameNode = new PhetPText(string, AbstractForcesAndMotionBasicsCanvas.DEFAULT_FONT){
            {
                super(string, font);
                if (textLocation == TextLocation.SIDE) {
                    if (d2 > 0.0) {
                        this.setOffset(arrowNode.getFullBounds().getMaxX() + 10.0, arrowNode.getFullBounds().getCenterY() - this.getFullBounds().getHeight() / 2.0);
                    } else {
                        this.setOffset(arrowNode.getFullBounds().getMinX() - this.getFullBounds().getWidth() - 10.0, arrowNode.getFullBounds().getCenterY() - this.getFullBounds().getHeight() / 2.0);
                    }
                } else {
                    this.setOffset(arrowNode.getFullBounds().getCenterX() - this.getFullBounds().getWidth() / 2.0, arrowNode.getFullBounds().getCenterY() - 24.0 - this.getFullBounds().getHeight() - 4.0);
                }
            }
        };
        this.addChild(this.nameNode);
        if (this.intersectsAny(option)) {
            this.nameNode.setOffset(arrowNode.getFullBounds().getCenterX() - this.nameNode.getFullBounds().getWidth() / 2.0, arrowNode.getFullBounds().getMaxY() + 10.0 - 2.0);
        }
        if (bl2) {
            final String string2 = new DecimalFormat("0").format(Math.abs(d));
            PhetPText phetPText = new PhetPText(new MessageFormat(ForcesAndMotionBasicsResources.Strings.FORCE_READOUT__PATTERN).format(new Object[]{string2}), new PhetFont(16, true)){
                {
                    super(string, font);
                    this.centerFullBoundsOnPoint(arrowNode.getFullBounds().getCenter2D());
                    double d2 = 2.0;
                    this.translate(d < 0.0 ? d2 : (d > 0.0 ? -d2 : 0.0), 0.0);
                    if (string2.length() <= 1) {
                        this.setOffset(ForceArrowNode.this.nameNode.getFullBounds().getCenterX() - this.getFullBounds().getWidth() / 2.0, ForceArrowNode.this.nameNode.getFullBounds().getMaxY() - 3.0);
                    }
                }
            };
            this.addChild(phetPText);
        }
    }

    private boolean intersectsAny(Option<ForceArrowNode> option) {
        return option.isSome() && MathUtil.getSign(this.forceInNewtons) == MathUtil.getSign(option.some().forceInNewtons);
    }

    private void showTextOnly(final Vector2D vector2D) {
        this.addChild(new PhetPText(ForcesAndMotionBasicsResources.Strings.SUM_OF_FORCES_EQUALS_ZERO, AbstractForcesAndMotionBasicsCanvas.DEFAULT_FONT){
            {
                super(string, font);
                this.centerBoundsOnPoint(vector2D.x, vector2D.y - 38.0);
            }
        });
    }
}

