/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forcesandmotionbasics.motion;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.Not;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.model.property.SettableProperty;
import edu.colorado.phet.common.phetcommon.model.property.doubleproperty.DoubleProperty;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.PhetPText;
import edu.colorado.phet.common.piccolophet.nodes.layout.HBox;
import edu.colorado.phet.common.piccolophet.nodes.layout.VBox;
import edu.colorado.phet.common.piccolophet.nodes.slider.HSliderNode;
import edu.colorado.phet.forcesandmotionbasics.ForcesAndMotionBasicsResources;
import edu.colorado.phet.forcesandmotionbasics.ForcesAndMotionBasicsSimSharing;
import edu.colorado.phet.forcesandmotionbasics.common.AbstractForcesAndMotionBasicsCanvas;
import edu.colorado.phet.forcesandmotionbasics.motion.MotionModel;
import edu.colorado.phet.forcesandmotionbasics.motion.SpeedValue;
import edu.colorado.phet.forcesandmotionbasics.motion.StackableNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolox.pswing.PSwing;
import fj.data.List;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AppliedForceSliderControl
extends PNode {
    public AppliedForceSliderControl(final ObservableProperty<SpeedValue> observableProperty, final DoubleProperty doubleProperty, final Property<List<StackableNode>> property, boolean bl, final BooleanProperty booleanProperty, final MotionModel motionModel) {
        final Not not = Not.not(property.valueEquals(List.nil()));
        String string = bl ? ForcesAndMotionBasicsResources.Strings.NEWTONS__N : ForcesAndMotionBasicsResources.Strings.NEWTONS;
        final SettableProperty<Double> settableProperty = new SettableProperty<Double>((Double)doubleProperty.get()){
            {
                super(d);
                observableProperty.addObserver(new VoidFunction1<SpeedValue>(){

                    @Override
                    public void apply(SpeedValue speedValue) {
                        this.set(this.get());
                    }
                });
            }

            @Override
            public void set(Double d) {
                if (observableProperty.get() == SpeedValue.WITHIN_ALLOWED_RANGE) {
                    doubleProperty.set(d);
                } else if (observableProperty.get() == SpeedValue.RIGHT_SPEED_EXCEEDED) {
                    doubleProperty.set(MathUtil.clamp(-500.0, d, 0.0));
                } else {
                    doubleProperty.set(MathUtil.clamp(0.0, d, 500.0));
                }
                this.notifyIfChanged();
            }

            @Override
            public Double get() {
                return (Double)doubleProperty.get();
            }
        };
        HSliderNode hSliderNode = new HSliderNode(ForcesAndMotionBasicsSimSharing.UserComponents.appliedForceSliderKnob, -500.0, 500.0, 6.0, 350.0, settableProperty, not){
            {
                super(iUserComponent, d, d2, d3, d4, settableProperty3, observableProperty3);
                PhetPPath phetPPath = this.addLabel(-500.0, new EnablePhetPText("-500", AbstractForcesAndMotionBasicsCanvas.DEFAULT_FONT, not), 15.0, 8.0);
                PhetPPath phetPPath2 = this.addLabel(-375.0, AppliedForceSliderControl.this.dummyLabel(), 10.0, 15.0);
                PhetPPath phetPPath3 = this.addLabel(-250.0, AppliedForceSliderControl.this.dummyLabel(), 15.0, 8.0);
                PhetPPath phetPPath4 = this.addLabel(-125.0, AppliedForceSliderControl.this.dummyLabel(), 10.0, 15.0);
                this.addLabel(0.0, new EnablePhetPText("0", AbstractForcesAndMotionBasicsCanvas.DEFAULT_FONT, not), 15.0, 8.0);
                PhetPPath phetPPath5 = this.addLabel(125.0, AppliedForceSliderControl.this.dummyLabel(), 10.0, 15.0);
                PhetPPath phetPPath6 = this.addLabel(250.0, AppliedForceSliderControl.this.dummyLabel(), 15.0, 8.0);
                PhetPPath phetPPath7 = this.addLabel(375.0, AppliedForceSliderControl.this.dummyLabel(), 10.0, 15.0);
                PhetPPath phetPPath8 = this.addLabel(500.0, new EnablePhetPText("500", AbstractForcesAndMotionBasicsCanvas.DEFAULT_FONT, not), 15.0, 8.0);
                observableProperty.addObserver(AppliedForceSliderControl.this.grayIf(phetPPath, SpeedValue.LEFT_SPEED_EXCEEDED));
                observableProperty.addObserver(AppliedForceSliderControl.this.grayIf(phetPPath3, SpeedValue.LEFT_SPEED_EXCEEDED));
                observableProperty.addObserver(AppliedForceSliderControl.this.grayIf(phetPPath6, SpeedValue.RIGHT_SPEED_EXCEEDED));
                observableProperty.addObserver(AppliedForceSliderControl.this.grayIf(phetPPath8, SpeedValue.RIGHT_SPEED_EXCEEDED));
                this.setTrackFillPaint(Color.white);
                this.getTrackNode().addChild(new PhetPPath(new Rectangle2D.Double(0.0, 0.0, this.getTrackNode().getFullBounds().getWidth(), this.getTrackNode().getFullBounds().getHeight() / 2.0), (Paint)Color.lightGray){
                    {
                        observableProperty.addObserver(new VoidFunction1<SpeedValue>(){

                            @Override
                            public void apply(SpeedValue speedValue) {
                                this.setVisible(speedValue == SpeedValue.RIGHT_SPEED_EXCEEDED);
                            }
                        });
                    }
                });
                this.getTrackNode().addChild(new PhetPPath(new Rectangle2D.Double(0.0, this.getTrackNode().getFullBounds().getHeight() / 2.0, this.getTrackNode().getFullBounds().getWidth(), this.getTrackNode().getFullBounds().getHeight() / 2.0), (Paint)Color.lightGray){
                    {
                        observableProperty.addObserver(new VoidFunction1<SpeedValue>(){

                            @Override
                            public void apply(SpeedValue speedValue) {
                                this.setVisible(speedValue == SpeedValue.LEFT_SPEED_EXCEEDED);
                            }
                        });
                    }
                });
                this.addInputEventListener(new PBasicInputEventHandler(){

                    public void mouseReleased(PInputEvent pInputEvent) {
                        if (((Boolean)booleanProperty.get()).booleanValue()) {
                            doubleProperty.set(0.0);
                            settableProperty.set(0.0);
                        }
                    }
                });
                property.addObserver(new VoidFunction1<List<StackableNode>>(){

                    @Override
                    public void apply(List<StackableNode> list) {
                        if (list.isEmpty()) {
                            settableProperty.set(0.0);
                            motionModel.speed.set(new Option.Some<Double>(0.0));
                            motionModel.velocity.set(0.0);
                        }
                    }
                });
            }
        };
        VBox vBox = new VBox(5.0, new EnablePhetPText(ForcesAndMotionBasicsResources.Strings.APPLIED_FORCE, AbstractForcesAndMotionBasicsCanvas.DEFAULT_FONT, not), hSliderNode, new HBox(new PhetPText(string, AbstractForcesAndMotionBasicsCanvas.DEFAULT_FONT){
            {
                this.setTransparency(0.0f);
            }
        }, new PSwing(new JTextField(3){
            {
                super(n);
                this.setFont(AbstractForcesAndMotionBasicsCanvas.DEFAULT_FONT);
                this.setText("0");
                final DecimalFormat decimalFormat = new DecimalFormat("0");
                this.setHorizontalAlignment(4);
                doubleProperty.addObserver(new VoidFunction1<Double>(){

                    @Override
                    public void apply(Double d) {
                        this.setText(decimalFormat.format(d));
                    }
                });
                not.addObserver(new VoidFunction1<Boolean>(){

                    @Override
                    public void apply(Boolean bl) {
                        this.setEnabled(bl);
                    }
                });
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        this.updateValueFromText(decimalFormat);
                    }
                });
                this.addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent focusEvent) {
                    }

                    public void focusLost(FocusEvent focusEvent) {
                        this.updateValueFromText(decimalFormat);
                    }
                });
            }

            private void updateValueFromText(DecimalFormat decimalFormat) {
                try {
                    double d = MathUtil.clamp(-500.0, decimalFormat.parse(this.getText()).doubleValue(), 500.0);
                    SimSharingManager.sendUserMessage(ForcesAndMotionBasicsSimSharing.UserComponents.appliedForceTextField, UserComponentTypes.textField, UserActions.textFieldCommitted, ParameterSet.parameterSet((IParameterKey)ForcesAndMotionBasicsSimSharing.ParameterKeys.appliedForce, d));
                    doubleProperty.set(d);
                    settableProperty.set(doubleProperty.get());
                }
                catch (ParseException parseException) {
                    this.setText(decimalFormat.format(doubleProperty.get()));
                }
            }
        }), new EnablePhetPText(string, AbstractForcesAndMotionBasicsCanvas.DEFAULT_FONT, not)));
        this.addChild(vBox);
    }

    private PhetPText dummyLabel() {
        return new PhetPText("a", AbstractForcesAndMotionBasicsCanvas.DEFAULT_FONT){
            {
                this.setTransparency(0.0f);
            }
        };
    }

    private VoidFunction1<SpeedValue> grayIf(final PhetPPath phetPPath, final SpeedValue speedValue) {
        return new VoidFunction1<SpeedValue>(){

            @Override
            public void apply(SpeedValue speedValue2) {
                phetPPath.setStrokePaint(speedValue2 == speedValue ? Color.gray : Color.black);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EnablePhetPText
    extends PhetPText {
        public EnablePhetPText(String string, Font font, ObservableProperty<Boolean> observableProperty) {
            super(string, font);
            observableProperty.addObserver(new VoidFunction1<Boolean>(){

                @Override
                public void apply(Boolean bl) {
                    EnablePhetPText.this.setTextPaint(bl != false ? Color.black : Color.gray);
                }
            });
        }
    }
}

