/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forcesandmotionbasics.motion;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.model.property.doubleproperty.CompositeDoubleProperty;
import edu.colorado.phet.common.phetcommon.model.property.doubleproperty.DoubleProperty;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ModelActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ModelComponentTypes;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterKeys;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.util.Pair;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.controls.PropertyCheckBox;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.ControlPanelNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.PhetPText;
import edu.colorado.phet.common.piccolophet.nodes.ResetAllButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.SpeedometerNode;
import edu.colorado.phet.common.piccolophet.nodes.background.SkyNode;
import edu.colorado.phet.common.piccolophet.nodes.layout.HBox;
import edu.colorado.phet.common.piccolophet.nodes.layout.VBox;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.PlayPauseButton;
import edu.colorado.phet.forcesandmotionbasics.ForcesAndMotionBasicsApplication;
import edu.colorado.phet.forcesandmotionbasics.ForcesAndMotionBasicsResources;
import edu.colorado.phet.forcesandmotionbasics.ForcesAndMotionBasicsSimSharing;
import edu.colorado.phet.forcesandmotionbasics.common.AbstractForcesAndMotionBasicsCanvas;
import edu.colorado.phet.forcesandmotionbasics.common.ForceArrowNode;
import edu.colorado.phet.forcesandmotionbasics.common.TextLocation;
import edu.colorado.phet.forcesandmotionbasics.motion.AccelerometerNode;
import edu.colorado.phet.forcesandmotionbasics.motion.AppliedForceSliderControl;
import edu.colorado.phet.forcesandmotionbasics.motion.FrictionSliderControl;
import edu.colorado.phet.forcesandmotionbasics.motion.MotionModel;
import edu.colorado.phet.forcesandmotionbasics.motion.PusherNode;
import edu.colorado.phet.forcesandmotionbasics.motion.SpeedValue;
import edu.colorado.phet.forcesandmotionbasics.motion.StackableNode;
import edu.colorado.phet.forcesandmotionbasics.motion.StackableNodeContext;
import edu.colorado.phet.forcesandmotionbasics.motion.WaterBucketNode;
import edu.colorado.phet.forcesandmotionbasics.tugofwar.ForcesNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.pswing.PSwing;
import fj.F;
import fj.F2;
import fj.P2;
import fj.data.List;
import fj.data.Option;
import fj.function.Doubles;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.Random;
import javax.swing.JCheckBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MotionCanvas
extends AbstractForcesAndMotionBasicsCanvas
implements StackableNodeContext {
    private final BooleanProperty showSpeedometer = new BooleanProperty(false);
    private final BooleanProperty showAccelerometer = new BooleanProperty(false);
    private final Property<Boolean> showValues = new Property<Boolean>(false);
    private final BooleanProperty showForces = new BooleanProperty(true);
    private final PNode skateboard;
    private final List<StackableNode> stackableNodes;
    private final Property<List<StackableNode>> stack = new Property(List.nil());
    private final boolean friction;
    private final MotionModel model;
    private final PNode forcesNode;
    private final BooleanProperty playing = new BooleanProperty(true);
    private final PusherNode pusherNode;
    private final BooleanProperty showSumOfForces = new BooleanProperty(false);
    private final BooleanProperty dragging = new BooleanProperty(false);
    private int lastNumSpecks = -1;
    private final boolean accelerometer;
    private final WaterBucketNode bucket;
    private final StackableNode fridge;
    private final StackableNode man;
    static final BufferedImage CLEAR = new BufferedImage(ForcesAndMotionBasicsResources.Images.ICE_OVERLAY.getWidth() / 8, 6, 3);
    BufferedImage gravelImage = new BufferedImage(CLEAR.getWidth(), CLEAR.getHeight(), 3);
    private static final Random random = new Random();

    public MotionCanvas(final Resettable resettable, IClock iClock, final boolean bl, boolean bl2) {
        this.accelerometer = bl2;
        this.friction = bl;
        CompositeDoubleProperty compositeDoubleProperty = new CompositeDoubleProperty(new Function0<Double>(){

            @Override
            public Double apply() {
                return MotionCanvas.this.getMassOfObjectsOnSkateboard();
            }
        }, (ObservableProperty<?>[])new ObservableProperty[]{this.stack});
        this.model = new MotionModel(bl, compositeDoubleProperty);
        this.setBackground(ForcesAndMotionBasicsApplication.BROWN);
        this.addChild(new SkyNode(ModelViewTransform.createIdentity(), new Rectangle2D.Double(-5000.0, -4575.0, 10000.0, 5000.0), 425.0, SkyNode.DEFAULT_TOP_COLOR, SkyNode.DEFAULT_BOTTOM_COLOR));
        final BufferedImage bufferedImage = new BufferedImage(3250, ForcesAndMotionBasicsResources.Images.MOUNTAINS.getHeight(), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawRenderedImage(ForcesAndMotionBasicsResources.Images.MOUNTAINS, new AffineTransform());
        graphics2D.dispose();
        PNode pNode = new PNode(){
            {
                this.addChild(new HBox(245.0, new PImage(ForcesAndMotionBasicsResources.Images.CLOUD1){
                    {
                        this.scale(0.6);
                    }
                }, new PhetPPath(new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0), (Paint)new Color(0, 0, 0, 0)){
                    {
                        this.setVisible(false);
                    }
                }));
            }
        };
        final Image image = pNode.toImage();
        final BufferedImage bufferedImage2 = BufferedImageUtils.toBufferedImage(image);
        PNode pNode2 = new PNode(){
            {
                ((MotionCanvas)MotionCanvas.this).model.position.addObserver(new VoidFunction1<Double>(){

                    @Override
                    public void apply(Double d) {
                        this.updateBackgroundLayer(d);
                    }
                });
                ((MotionCanvas)MotionCanvas.this).model.frictionValue.addObserver(new VoidFunction1<Double>(){

                    @Override
                    public void apply(Double d) {
                        this.updateBackgroundLayer((Double)((MotionCanvas)MotionCanvas.this).model.position.get());
                    }
                });
            }

            private void updateBackgroundLayer(Double d) {
                this.removeAllChildren();
                Object object = new Rectangle2D.Double(-AbstractForcesAndMotionBasicsCanvas.STAGE_SIZE.width / 0.25, 1700.0 - (double)bufferedImage.getHeight(), AbstractForcesAndMotionBasicsCanvas.STAGE_SIZE.width * 3.0 / 0.25, bufferedImage.getHeight());
                Rectangle2D.Double double_ = new Rectangle2D.Double(-d.doubleValue() * 100.0 / 0.25 / 50.0 + 150.0, ((Rectangle2D.Double)object).getY() - 1.0, bufferedImage.getWidth(), bufferedImage.getHeight());
                Cloneable cloneable = new PhetPPath((Shape)object, (Paint)new TexturePaint(bufferedImage, double_)){
                    {
                        this.scale(0.25);
                    }
                };
                cloneable.setTransparency(0.6f);
                this.addChild((PNode)cloneable);
                object = new Rectangle2D.Double(-AbstractForcesAndMotionBasicsCanvas.STAGE_SIZE.width / 0.4, 1062.5, AbstractForcesAndMotionBasicsCanvas.STAGE_SIZE.width * 3.0 / 0.4, ForcesAndMotionBasicsResources.Images.BRICK_TILE.getHeight());
                double_ = new Rectangle2D.Double(-d.doubleValue() * 100.0 / 0.4, ((Rectangle2D.Double)object).getY(), ForcesAndMotionBasicsResources.Images.BRICK_TILE.getWidth(), ForcesAndMotionBasicsResources.Images.BRICK_TILE.getHeight());
                cloneable = new PhetPPath((Shape)object, (Paint)new TexturePaint(ForcesAndMotionBasicsResources.Images.BRICK_TILE, double_)){
                    {
                        this.scale(0.4);
                    }
                };
                this.addChild((PNode)cloneable);
                if (bl && (Double)((MotionCanvas)MotionCanvas.this).model.frictionValue.get() == 0.0) {
                    object = new Rectangle2D.Double(-AbstractForcesAndMotionBasicsCanvas.STAGE_SIZE.width / 1.0, 424.0, AbstractForcesAndMotionBasicsCanvas.STAGE_SIZE.width * 3.0 / 1.0, ForcesAndMotionBasicsResources.Images.ICE_OVERLAY.getHeight());
                    double_ = new Rectangle2D.Double(-d.doubleValue() * 100.0 / 1.0, ((Rectangle2D.Double)object).getY(), ForcesAndMotionBasicsResources.Images.ICE_OVERLAY.getWidth(), ForcesAndMotionBasicsResources.Images.ICE_OVERLAY.getHeight());
                    cloneable = new PhetPPath((Shape)object, (Paint)new TexturePaint(ForcesAndMotionBasicsResources.Images.ICE_OVERLAY, double_)){
                        {
                            this.scale(1.0);
                        }
                    };
                    cloneable.setTransparency(0.9f);
                    this.addChild((PNode)cloneable);
                }
                Rectangle2D.Double double_2 = new Rectangle2D.Double(-AbstractForcesAndMotionBasicsCanvas.STAGE_SIZE.width, -50.0, AbstractForcesAndMotionBasicsCanvas.STAGE_SIZE.width * 3.0, image.getHeight(null));
                Rectangle2D.Double double_3 = new Rectangle2D.Double(-d.doubleValue() * 10.0, double_2.getY(), image.getWidth(null), image.getHeight(null));
                this.addChild(new PhetPPath((Shape)double_2, (Paint)new TexturePaint(bufferedImage2, double_3)));
                if (bl && (Double)((MotionCanvas)MotionCanvas.this).model.frictionValue.get() > 0.0) {
                    MotionCanvas.this.updateGravelImage();
                    object = MotionCanvas.this.gravelImage;
                    double_ = new Rectangle2D.Double(-AbstractForcesAndMotionBasicsCanvas.STAGE_SIZE.width / 1.0, 423.25, AbstractForcesAndMotionBasicsCanvas.STAGE_SIZE.width * 3.0 / 1.0, ((BufferedImage)object).getHeight());
                    cloneable = new Rectangle2D.Double(-d.doubleValue() * 100.0 / 1.0, double_.getY(), ((BufferedImage)object).getWidth(), ((BufferedImage)object).getHeight());
                    PhetPPath phetPPath = new PhetPPath(double_, (Paint)new TexturePaint((BufferedImage)object, (Rectangle2D)cloneable)){
                        {
                            this.scale(1.0);
                        }
                    };
                    this.addChild(phetPPath);
                }
            }
        };
        this.addChild(pNode2);
        PropertyCheckBox propertyCheckBox = new PropertyCheckBox(ForcesAndMotionBasicsSimSharing.UserComponents.forcesCheckBox, bl ? ForcesAndMotionBasicsResources.Strings.FORCES : ForcesAndMotionBasicsResources.Strings.FORCE, this.showForces){
            {
                this.setFont(AbstractForcesAndMotionBasicsCanvas.DEFAULT_FONT);
            }
        };
        final PropertyCheckBox propertyCheckBox2 = new PropertyCheckBox(ForcesAndMotionBasicsSimSharing.UserComponents.valuesCheckBox, ForcesAndMotionBasicsResources.Strings.VALUES, this.showValues){
            {
                this.setFont(AbstractForcesAndMotionBasicsCanvas.DEFAULT_FONT);
            }
        };
        final PropertyCheckBox propertyCheckBox3 = new PropertyCheckBox(ForcesAndMotionBasicsSimSharing.UserComponents.sumOfForcesCheckBox, ForcesAndMotionBasicsResources.Strings.SUM_OF_FORCES, this.showSumOfForces){
            {
                this.setFont(AbstractForcesAndMotionBasicsCanvas.DEFAULT_FONT);
            }
        };
        this.showForces.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                propertyCheckBox2.setEnabled(bl);
                propertyCheckBox3.setEnabled(bl);
            }
        });
        PropertyCheckBox propertyCheckBox4 = new PropertyCheckBox(ForcesAndMotionBasicsSimSharing.UserComponents.speedCheckBox, ForcesAndMotionBasicsResources.Strings.SPEED, this.showSpeedometer){
            {
                this.setFont(AbstractForcesAndMotionBasicsCanvas.DEFAULT_FONT);
            }
        };
        BooleanProperty booleanProperty = new BooleanProperty(false);
        PropertyCheckBox propertyCheckBox5 = new PropertyCheckBox(ForcesAndMotionBasicsSimSharing.UserComponents.massCheckBox, ForcesAndMotionBasicsResources.Strings.MASSES, booleanProperty){
            {
                this.setFont(AbstractForcesAndMotionBasicsCanvas.DEFAULT_FONT);
            }
        };
        HBox hBox = new HBox(15.0, new PSwing(propertyCheckBox4), new SpeedometerNode(ForcesAndMotionBasicsResources.Strings.SPEED, 125.0, this.model.speed, 20.0){
            {
                this.scale(0.25);
                this.addInputEventListener(new CursorHandler());
                this.addInputEventListener(new PBasicInputEventHandler(){

                    public void mousePressed(PInputEvent pInputEvent) {
                        SimSharingManager.sendUserMessage(ForcesAndMotionBasicsSimSharing.UserComponents.speedCheckBoxIcon, UserComponentTypes.button, UserActions.pressed, ParameterSet.parameterSet((IParameterKey)ParameterKeys.isSelected, (Boolean)MotionCanvas.this.showSpeedometer.get() == false));
                        MotionCanvas.this.showSpeedometer.toggle();
                    }
                });
            }
        });
        HBox hBox2 = new HBox(15.0, new PSwing(propertyCheckBox), new ForceArrowNode(false, Vector2D.ZERO, 100.0, "", ForcesNode.APPLIED_FORCE_COLOR, TextLocation.SIDE, false){
            {
                this.scale(0.4);
                this.setPickable(true);
                this.setChildrenPickable(true);
                this.addInputEventListener(new PBasicInputEventHandler(){

                    public void mousePressed(PInputEvent pInputEvent) {
                        SimSharingManager.sendUserMessage(ForcesAndMotionBasicsSimSharing.UserComponents.showForcesCheckBoxIcon, UserComponentTypes.button, UserActions.pressed, ParameterSet.parameterSet((IParameterKey)ParameterKeys.isSelected, (Boolean)MotionCanvas.this.showForces.get() == false));
                        MotionCanvas.this.showForces.toggle();
                    }
                });
                this.addInputEventListener(new CursorHandler());
            }
        });
        HBox hBox3 = new HBox(15.0, new PSwing(propertyCheckBox3));
        VBox vBox = bl ? (bl2 ? new VBox(0.0, VBox.LEFT_ALIGNED, hBox2, this.indent(hBox3), this.indent(propertyCheckBox2), new PSwing(propertyCheckBox5), hBox, this.createAccelerometerCheckBox(), new FrictionSliderControl(this.model.frictionValue)) : new VBox(0.0, VBox.LEFT_ALIGNED, hBox2, this.indent(hBox3), this.indent(propertyCheckBox2), new PSwing(propertyCheckBox5), hBox, new FrictionSliderControl(this.model.frictionValue))) : new VBox(0.0, VBox.LEFT_ALIGNED, hBox2, this.indent(propertyCheckBox2), new PSwing(propertyCheckBox5), hBox);
        final ControlPanelNode controlPanelNode = new ControlPanelNode((PNode)vBox, new Color(227, 233, 128), new BasicStroke(2.0f), Color.black);
        controlPanelNode.setOffset(MotionCanvas.STAGE_SIZE.width - controlPanelNode.getFullWidth() - 10.0, 10.0);
        this.addChild(controlPanelNode);
        this.addChild(new ResetAllButtonNode(new Resettable(){

            public void reset() {
                resettable.reset();
            }
        }, this, DEFAULT_FONT, Color.black, Color.orange){
            {
                super(resettable, component, font, color, color2);
                this.setOffset(controlPanelNode.getFullBounds().getCenterX() - this.getFullBounds().getWidth() / 2.0, controlPanelNode.getMaxY() + 10.0);
                this.setConfirmationEnabled(false);
            }
        });
        this.skateboard = bl ? new PhetPPath(new Rectangle(0, 0, ForcesAndMotionBasicsResources.Images.SKATEBOARD.getWidth(), 1), new Color(0, 0, 0, 0), null, null) : new PImage(ForcesAndMotionBasicsResources.Images.SKATEBOARD);
        this.skateboard.setScale(0.85);
        this.skateboard.setOffset(STAGE_SIZE.getWidth() / 2.0 - this.skateboard.getFullBounds().getWidth() / 2.0, 425.0 - this.skateboard.getFullBounds().getHeight());
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, 270.0, 170.0, 20.0, 20.0);
        PhetPPath phetPPath = new PhetPPath(double_, ForcesAndMotionBasicsApplication.TOOLBOX_COLOR, new BasicStroke(1.0f), Color.black);
        double d = MotionCanvas.STAGE_SIZE.height - 10.0 - phetPPath.getFullBounds().getHeight();
        phetPPath.setOffset(10.0, d);
        this.addChild(phetPPath);
        PhetPPath phetPPath2 = new PhetPPath(double_, ForcesAndMotionBasicsApplication.TOOLBOX_COLOR, new BasicStroke(1.0f), Color.black);
        phetPPath2.setOffset(MotionCanvas.STAGE_SIZE.width - 10.0 - phetPPath2.getFullBounds().getWidth(), d);
        this.addChild(phetPPath2);
        AppliedForceSliderControl appliedForceSliderControl = new AppliedForceSliderControl(this.model.speedValue, this.model.appliedForce, this.stack, bl, this.playing, this.model);
        appliedForceSliderControl.setOffset(STAGE_SIZE.getWidth() / 2.0 - appliedForceSliderControl.getFullBounds().getWidth() / 2.0, 475.0);
        this.addChild(appliedForceSliderControl);
        this.pusherNode = new PusherNode(this.model.fallen, this.skateboard, 425.0, this.model.appliedForce, this.stack, this.model.speedValue, this.model.velocity, this.playing, this.model.movedSliderOnce);
        this.addChild(this.pusherNode);
        this.addChild(this.skateboard);
        PlayPauseButton playPauseButton = new PlayPauseButton(70){
            {
                this.addListener(new PlayPauseButton.Listener(){

                    public void playbackStateChanged() {
                        MotionCanvas.this.playbackStateChanged(this.isPlaying());
                    }
                });
            }
        };
        HBox hBox4 = new HBox(-3.0, playPauseButton);
        hBox4.setOffset(MotionCanvas.STAGE_SIZE.width / 2.0 - playPauseButton.getFullBounds().getWidth() / 2.0, MotionCanvas.STAGE_SIZE.height - hBox4.getFullHeight());
        this.addChild(hBox4);
        this.fridge = new StackableNode(ForcesAndMotionBasicsSimSharing.UserComponents.fridge, this, ForcesAndMotionBasicsResources.Images.FRIDGE, 200.0, 21, booleanProperty);
        StackableNode stackableNode = new StackableNode(ForcesAndMotionBasicsSimSharing.UserComponents.crate1, this, BufferedImageUtils.multiScaleToHeight(ForcesAndMotionBasicsResources.Images.CRATE, 90), 50.0, 27, booleanProperty);
        StackableNode stackableNode2 = new StackableNode(ForcesAndMotionBasicsSimSharing.UserComponents.crate2, this, BufferedImageUtils.multiScaleToHeight(ForcesAndMotionBasicsResources.Images.CRATE, 90), 50.0, 27, booleanProperty);
        double d2 = 10.0;
        this.fridge.setInitialOffset(phetPPath.getFullBounds().getX() + 10.0, phetPPath.getFullBounds().getCenterY() - this.fridge.getFullBounds().getHeight() / 2.0);
        stackableNode.setInitialOffset(this.fridge.getObjectMaxX() + d2, this.fridge.getFullBounds().getMaxY() - stackableNode.getFullBounds().getHeight());
        stackableNode2.setInitialOffset(stackableNode.getObjectMaxX() + d2, this.fridge.getFullBounds().getMaxY() - stackableNode2.getFullBounds().getHeight());
        this.addChild(this.fridge);
        this.addChild(stackableNode);
        this.addChild(stackableNode2);
        StackableNode stackableNode3 = new StackableNode(ForcesAndMotionBasicsSimSharing.UserComponents.girl, this, BufferedImageUtils.multiScaleToHeight(ForcesAndMotionBasicsResources.Images.GIRL_SITTING, 100), 40.0, bl ? 38 : 47, booleanProperty, true, BufferedImageUtils.multiScaleToHeight(ForcesAndMotionBasicsResources.Images.GIRL_STANDING, 150), BufferedImageUtils.multiScaleToHeight(ForcesAndMotionBasicsResources.Images.GIRL_HOLDING, 100));
        this.man = new StackableNode(ForcesAndMotionBasicsSimSharing.UserComponents.man, this, BufferedImageUtils.multiScaleToHeight(ForcesAndMotionBasicsResources.Images.MAN_SITTING, 133), 80.0, 38, booleanProperty, true, BufferedImageUtils.multiScaleToHeight(ForcesAndMotionBasicsResources.Images.MAN_STANDING, 200), BufferedImageUtils.multiScaleToHeight(ForcesAndMotionBasicsResources.Images.MAN_HOLDING, 133));
        StackableNode stackableNode4 = new StackableNode(ForcesAndMotionBasicsSimSharing.UserComponents.trash, this, BufferedImageUtils.multiScaleToHeight(ForcesAndMotionBasicsResources.Images.TRASH_CAN, 100), 50.0, 47, booleanProperty);
        this.bucket = new WaterBucketNode(ForcesAndMotionBasicsSimSharing.UserComponents.bucket, this, BufferedImageUtils.multiScaleToHeight(ForcesAndMotionBasicsResources.Images.WATER_BUCKET, 100), 50.0, 28, booleanProperty, this.model.acceleration);
        StackableNode stackableNode5 = new StackableNode(ForcesAndMotionBasicsSimSharing.UserComponents.gift, this, BufferedImageUtils.multiScaleToHeight(ForcesAndMotionBasicsResources.Images.MYSTERY_OBJECT_01, 60), 50.0, 40, booleanProperty){

            @Override
            protected Pair<Integer, String> getMassDisplayString(double d) {
                return new Pair<Integer, String>(12, "?");
            }
        };
        double d3 = bl2 ? 29.0 : 18.0;
        stackableNode3.setInitialOffset(phetPPath2.getFullBounds().getX() + d3, phetPPath2.getFullBounds().getMaxY() - stackableNode3.getFullBounds().getHeight() - 5.0);
        this.man.setInitialOffset(stackableNode3.getObjectMaxX() + d3, phetPPath2.getFullBounds().getMaxY() - this.man.getFullBounds().getHeight() - 5.0);
        StackableNode stackableNode6 = bl2 ? this.bucket : stackableNode4;
        stackableNode6.setInitialOffset(this.man.getObjectMaxX() + d3, phetPPath2.getFullBounds().getMaxY() - stackableNode6.getFullBounds().getHeight() - 5.0);
        stackableNode5.setInitialOffset(stackableNode6.getObjectMaxX() + d3 - 5.0, phetPPath2.getFullBounds().getMaxY() - stackableNode5.getFullBounds().getHeight() - 5.0);
        this.addChild(stackableNode3);
        this.addChild(this.man);
        this.addChild(stackableNode6);
        List<StackableNode> list = this.stackableNodes = bl2 ? List.list(this.fridge, stackableNode, stackableNode2, this.man, stackableNode3, stackableNode6) : List.list(this.fridge, stackableNode, stackableNode2, this.man, stackableNode3, stackableNode6, stackableNode5);
        if (!bl2) {
            this.addChild(stackableNode5);
        }
        iClock.addClockListener(new ClockAdapter(){

            public void simulationTimeChanged(ClockEvent clockEvent) {
                if (((Boolean)MotionCanvas.this.playing.get()).booleanValue()) {
                    MotionCanvas.this.step(clockEvent.getSimulationTimeChange());
                }
                MotionCanvas.this.model.clockStepped();
            }
        });
        this.forcesNode = new PNode(){
            {
                SimpleObserver simpleObserver = new SimpleObserver(){

                    public void update() {
                        this.removeAllChildren();
                        if (((Boolean)MotionCanvas.this.showForces.get()).booleanValue()) {
                            double d = MotionCanvas.this.skateboard.getFullBounds().getCenterY() - 75.0;
                            double d2 = MotionCanvas.this.skateboard.getFullBounds().getCenterX();
                            int n = bl && (Double)((MotionCanvas)MotionCanvas.this).model.frictionForce.get() != 0.0 ? 3 * MathUtil.getSign((Double)((MotionCanvas)MotionCanvas.this).model.appliedForce.get()) : 0;
                            ForceArrowNode forceArrowNode = new ForceArrowNode(false, Vector2D.v(d2 + (double)n, d), (Double)((MotionCanvas)MotionCanvas.this).model.appliedForce.get(), ForcesAndMotionBasicsResources.Strings.APPLIED_FORCE, ForcesNode.APPLIED_FORCE_COLOR, TextLocation.SIDE, (Boolean)MotionCanvas.this.showValues.get());
                            this.addChild(forceArrowNode);
                            int n2 = bl ? 3 * MathUtil.getSign((Double)((MotionCanvas)MotionCanvas.this).model.frictionForce.get()) : 0;
                            this.addChild(new ForceArrowNode(false, Vector2D.v(d2 + (double)n2, d), (Double)((MotionCanvas)MotionCanvas.this).model.frictionForce.get(), ForcesAndMotionBasicsResources.Strings.FRICTION_FORCE, Color.red, TextLocation.SIDE, (Boolean)MotionCanvas.this.showValues.get(), Option.some(forceArrowNode)));
                            if (bl && ((Boolean)MotionCanvas.this.showSumOfForces.get()).booleanValue()) {
                                this.addChild(new ForceArrowNode(false, Vector2D.v(d2, d - 70.0), (Double)((MotionCanvas)MotionCanvas.this).model.sumOfForces.get(), ForcesAndMotionBasicsResources.Strings.SUM_OF_FORCES, ForcesNode.SUM_OF_FORCES_COLOR, TextLocation.TOP, (Boolean)MotionCanvas.this.showValues.get()));
                            }
                        }
                    }
                };
                MotionCanvas.this.showValues.addObserver(simpleObserver);
                ((MotionCanvas)MotionCanvas.this).model.appliedForce.addObserver(simpleObserver);
                ((MotionCanvas)MotionCanvas.this).model.frictionForce.addObserver(simpleObserver);
                ((MotionCanvas)MotionCanvas.this).model.sumOfForces.addObserver(simpleObserver);
                MotionCanvas.this.showForces.addObserver(simpleObserver);
                MotionCanvas.this.showSumOfForces.addObserver(simpleObserver);
            }
        };
        this.addChild(this.forcesNode);
        SpeedometerNode speedometerNode = new SpeedometerNode(ForcesAndMotionBasicsResources.Strings.SPEED, 125.0, this.model.speed, 20.0){
            {
                MotionCanvas.this.showSpeedometer.addObserver(new VoidFunction1<Boolean>(){

                    @Override
                    public void apply(Boolean bl) {
                        this.setVisible(bl);
                    }
                });
                this.scale(1.25);
            }
        };
        this.addChild(speedometerNode);
        PNode pNode3 = new PNode(){
            {
                final AccelerometerNode accelerometerNode = new AccelerometerNode(((MotionCanvas)MotionCanvas.this).model.acceleration);
                this.addChild(new VBox(0.0, new PhetPText(ForcesAndMotionBasicsResources.Strings.ACCELERATION, new PhetFont(20)), accelerometerNode));
                this.addChild(new PhetPText("-20", new PhetFont(15)){
                    {
                        super(string, font);
                        this.setOffset(accelerometerNode.ticks.get(0).getGlobalFullBounds().getCenterX() - this.getFullBounds().getWidth() / 2.0, accelerometerNode.getGlobalFullBounds().getMaxY());
                    }
                });
                this.addChild(new PhetPText("0", new PhetFont(15)){
                    {
                        super(string, font);
                        this.setOffset(accelerometerNode.ticks.get(2).getGlobalFullBounds().getCenterX() - this.getFullBounds().getWidth() / 2.0, accelerometerNode.getGlobalFullBounds().getMaxY());
                    }
                });
                this.addChild(new PhetPText("20", new PhetFont(15)){
                    {
                        super(string, font);
                        this.setOffset(accelerometerNode.ticks.get(4).getGlobalFullBounds().getCenterX() - this.getFullBounds().getWidth() / 2.0, accelerometerNode.getGlobalFullBounds().getMaxY());
                    }
                });
                MotionCanvas.this.showAccelerometer.addObserver(new VoidFunction1<Boolean>(){

                    @Override
                    public void apply(Boolean bl) {
                        this.setVisible(bl);
                    }
                });
            }
        };
        this.addChild(pNode3);
        this.addChild(new VBox(0.0, new PNode[]{speedometerNode, pNode3}){
            {
                this.setOffset(AbstractForcesAndMotionBasicsCanvas.STAGE_SIZE.width / 2.0 - this.getFullBounds().getWidth() / 2.0, 2.0);
                MotionCanvas.this.stack.addObserver(new VoidFunction1<List<StackableNode>>(){

                    @Override
                    public void apply(List<StackableNode> list) {
                        if (list.length() >= 3 || list.length() == 2 && MotionCanvas.this.stackContainsFridgeOrMan()) {
                            this.animateToPositionScaleRotation(AbstractForcesAndMotionBasicsCanvas.STAGE_SIZE.width / 2.0 - this.getFullBounds().getWidth() / 2.0 - this.getFullBounds().getWidth(), 2.0, 1.0, 0.0, 200L);
                        } else {
                            this.animateToPositionScaleRotation(AbstractForcesAndMotionBasicsCanvas.STAGE_SIZE.width / 2.0 - this.getFullBounds().getWidth() / 2.0, 2.0, 1.0, 0.0, 200L);
                        }
                    }
                });
            }
        });
        this.stack.addObserver(new VoidFunction1<List<StackableNode>>(){

            @Override
            public void apply(List<StackableNode> list) {
                if (list.length() == 0) {
                    ((MotionCanvas)MotionCanvas.this).model.appliedForce.set(0.0);
                    ((MotionCanvas)MotionCanvas.this).model.velocity.set(0.0);
                }
            }
        });
        this.stack.addObserver(new VoidFunction1<List<StackableNode>>(){

            @Override
            public void apply(List<StackableNode> list) {
                SimSharingManager.sendModelMessage(ForcesAndMotionBasicsSimSharing.ModelComponents.stack, ModelComponentTypes.modelElement, ModelActions.changed, ParameterSet.parameterSet((IParameterKey)ForcesAndMotionBasicsSimSharing.ParameterKeys.mass, MotionCanvas.this.getMassOfObjectsOnSkateboard()).with((IParameterKey)ForcesAndMotionBasicsSimSharing.ParameterKeys.items, MotionCanvas.this.stackToString(list)));
            }
        });
    }

    private boolean stackContainsFridgeOrMan() {
        return this.isInStack(this.fridge) || this.isInStack(this.man);
    }

    private PNode createAccelerometerCheckBox() {
        PropertyCheckBox propertyCheckBox = new PropertyCheckBox(ForcesAndMotionBasicsSimSharing.UserComponents.accelerometerCheckBox, ForcesAndMotionBasicsResources.Strings.ACCELERATION, this.showAccelerometer){
            {
                this.setFont(AbstractForcesAndMotionBasicsCanvas.DEFAULT_FONT);
            }
        };
        return new HBox(15.0, new PSwing(propertyCheckBox), new AccelerometerNode(this.model.acceleration){
            {
                this.scale(0.25);
                this.addInputEventListener(new CursorHandler());
                this.addInputEventListener(new PBasicInputEventHandler(){

                    public void mousePressed(PInputEvent pInputEvent) {
                        SimSharingManager.sendUserMessage(ForcesAndMotionBasicsSimSharing.UserComponents.accelerometerCheckBoxIcon, UserComponentTypes.button, UserActions.pressed, ParameterSet.parameterSet((IParameterKey)ParameterKeys.isSelected, (Boolean)MotionCanvas.this.showAccelerometer.get() == false));
                        MotionCanvas.this.showAccelerometer.toggle();
                    }
                });
            }
        });
    }

    private void updateGravelImage() {
        int n;
        Function.LinearFunction linearFunction = new Function.LinearFunction(0.05, 0.5, 0.0, 575.0);
        int n2 = (int)linearFunction.evaluate((Double)this.model.frictionValue.get());
        if (n2 == this.lastNumSpecks) {
            return;
        }
        this.gravelImage.setData(CLEAR.getRaster());
        Graphics2D graphics2D = this.gravelImage.createGraphics();
        random.setSeed(0L);
        graphics2D.setPaint(Color.black);
        int n3 = this.gravelImage.getWidth();
        int n4 = this.gravelImage.getHeight();
        for (n = 0; n < n2 / 2; ++n) {
            graphics2D.fillRect(random.nextInt(n3), random.nextInt(n4), 1, 1);
        }
        graphics2D.setPaint(Color.darkGray);
        for (n = 0; n < n2 / 2; ++n) {
            graphics2D.fillRect(random.nextInt(n3), random.nextInt(n4), 1, 1);
        }
        random.setSeed(11L);
        graphics2D.setPaint(Color.white);
        for (n = 0; n < n2 / 10; ++n) {
            graphics2D.fillRect(random.nextInt(n3), random.nextInt(n4), 1, 1);
        }
        graphics2D.dispose();
        this.lastNumSpecks = n2;
    }

    private String stackToString(List<StackableNode> list) {
        return list.foldLeft(new F2<String, StackableNode, String>(){

            @Override
            public String f(String string, StackableNode stackableNode) {
                return string + ", " + stackableNode.component.toString();
            }
        }, this.friction ? "ground" : "skateboard");
    }

    private PNode indent(JCheckBox jCheckBox) {
        return this.indent(new PSwing(jCheckBox));
    }

    private PNode indent(PNode pNode) {
        return new HBox(15.0, new PhetPPath((Shape)new Rectangle(0, 0, 1, 1), (Paint)new Color(0, 0, 0, 0)), pNode);
    }

    private void step(double d) {
        boolean bl;
        boolean bl2 = this.model.speed.get().get() >= 20.0;
        this.model.stepInTime(d);
        boolean bl3 = bl = this.model.speed.get().get() >= 20.0;
        if ((Double)this.model.appliedForce.get() == 0.0 || bl2) {
            double d2 = -((Double)this.model.velocity.get()).doubleValue() * d * 100.0;
            this.pusherNode.setOffset(this.pusherNode.getOffset().getX() + d2, this.pusherNode.getOffset().getY());
        }
        if (bl2 || bl || this.friction && this.model.speedValue.get() != SpeedValue.WITHIN_ALLOWED_RANGE) {
            this.model.fallen.set(true);
        } else {
            this.model.fallen.set(false);
        }
        this.bucket.stepInTime();
    }

    private void playbackStateChanged(boolean bl) {
        this.playing.set(bl);
    }

    private double getMassOfObjectsOnSkateboard() {
        return this.stackableNodes == null ? 0.0 : this.stackableNodes.filter(StackableNode._isOnSkateboard).map(StackableNode._mass).foldLeft(Doubles.add, Double.valueOf(0.0));
    }

    @Override
    public void stackableNodeDropped(StackableNode stackableNode) {
        PBounds pBounds = this.skateboard.getGlobalFullBounds();
        pBounds.add(this.skateboard.getGlobalFullBounds().getCenterX(), this.rootNode.globalToLocal(new Point2D.Double(MotionCanvas.STAGE_SIZE.width / 2.0, 0.0)).getY());
        if (stackableNode.getGlobalFullBounds().getMinY() < this.skateboard.getGlobalFullBounds().getMaxY() && this.stack.get().length() < 3) {
            stackableNode.onSkateboard.set(true);
            this.stack.set(this.stack.get().snoc(stackableNode));
            this.normalizeStack();
        } else {
            stackableNode.animateHome();
        }
        this.dragging.set(false);
    }

    @Override
    public void stackableNodePressed(final StackableNode stackableNode) {
        this.dragging.set(true);
        if (((Boolean)stackableNode.onSkateboard.get()).booleanValue()) {
            double d = stackableNode.getFullBounds().getWidth() / 4.0;
            stackableNode.translate(d, d);
        }
        stackableNode.moveToFront();
        this.nodeMovedToFront();
        stackableNode.onSkateboard.set(false);
        this.stack.set(this.stack.get().filter(new F<StackableNode, Boolean>(){

            @Override
            public Boolean f(StackableNode stackableNode2) {
                return stackableNode2 != stackableNode;
            }
        }));
        this.normalizeStack();
    }

    @Override
    public DoubleProperty getAppliedForce() {
        return this.model.appliedForce;
    }

    @Override
    public BooleanProperty getUserIsDraggingSomething() {
        return this.dragging;
    }

    @Override
    public boolean isInStackButNotInTop(final StackableNode stackableNode) {
        return this.stack.get().reverse().tail().exists(new F<StackableNode, Boolean>(){

            @Override
            public Boolean f(StackableNode stackableNode2) {
                return stackableNode2 == stackableNode;
            }
        });
    }

    @Override
    public boolean isInStack(final StackableNode stackableNode) {
        return this.stack.get().exists(new F<StackableNode, Boolean>(){

            @Override
            public Boolean f(StackableNode stackableNode2) {
                return stackableNode2 == stackableNode;
            }
        });
    }

    @Override
    public void addStackChangeListener(SimpleObserver simpleObserver) {
        this.stack.addObserver(simpleObserver);
    }

    @Override
    public int getStackSize() {
        return this.stack.get().length();
    }

    private void nodeMovedToFront() {
        this.forcesNode.moveToFront();
    }

    private void normalizeStack() {
        List<StackableNode> list = this.stack.get();
        for (P2<StackableNode, Integer> p2 : list.zipIndex()) {
            int n = p2._2();
            StackableNode stackableNode = p2._1();
            Rectangle2D rectangle2D = stackableNode.getParent().globalToLocal(this.skateboard.getGlobalFullBounds());
            double d = rectangle2D.getY() + (double)(this.friction ? 1 : 6);
            double d2 = -list.take(n).map(new F<StackableNode, Double>(){

                @Override
                public Double f(StackableNode stackableNode) {
                    return stackableNode.getFullScaleHeight();
                }
            }).foldLeft(Doubles.add, Double.valueOf(0.0)).doubleValue() + d;
            stackableNode.animateToPositionScaleRotation(rectangle2D.getCenterX() - stackableNode.getFullScaleWidth() / 2.0 + stackableNode.getInset(), d2 - stackableNode.getFullScaleHeight(), 1.0, 0.0, 200L);
        }
    }
}

