/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forcesandmotionbasics.motion;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.model.property.SettableProperty;
import edu.colorado.phet.common.phetcommon.model.property.doubleproperty.DoubleProperty;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.common.phetcommon.util.Pair;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.forcesandmotionbasics.motion.SpeedValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MotionModel {
    public final DoubleProperty appliedForce = new DoubleProperty(0.0);
    public final DoubleProperty frictionForce = new DoubleProperty(0.0);
    public final DoubleProperty sumOfForces = new DoubleProperty(0.0);
    public final DoubleProperty velocity = new DoubleProperty(0.0);
    public final DoubleProperty position = new DoubleProperty(0.0);
    public final Property<Option<Double>> speed = new Property<Option.Some<Double>>(new Option.Some<Double>(0.0));
    public final Property<Option<Double>> acceleration = new Property<Option.Some<Double>>(new Option.Some<Double>(0.0));
    private final boolean friction;
    private final ObservableProperty<Double> massOfObjectsOnSkateboard;
    public final BooleanProperty fallen = new BooleanProperty(false);
    private final Property<SpeedValue> _speedValue = new Property<SpeedValue>(SpeedValue.WITHIN_ALLOWED_RANGE);
    public final Property<SpeedValue> speedValue = new Property<SpeedValue>(this._speedValue.get());
    public final SettableProperty<Double> frictionValue = new Property<Double>(0.25);
    private Pair<Long, SpeedValue> lastOutOfRange = null;
    public final BooleanProperty movedSliderOnce = new BooleanProperty(false);

    public MotionModel(boolean bl, ObservableProperty<Double> observableProperty) {
        this.friction = bl;
        this.massOfObjectsOnSkateboard = observableProperty;
        new RichSimpleObserver(){

            public void update() {
                MotionModel.this.updateForces();
            }
        }.observe(this.frictionValue, observableProperty, this.appliedForce);
        this.appliedForce.addObserver(new VoidFunction1<Double>(){

            @Override
            public void apply(Double d) {
                if (d != 0.0) {
                    MotionModel.this.movedSliderOnce.set(true);
                }
            }
        });
    }

    public void stepInTime(double d) {
        double d2 = this.updateForces();
        double d3 = this.massOfObjectsOnSkateboard.get();
        double d4 = d3 != 0.0 ? d2 / d3 : 0.0;
        this.acceleration.set(new Option.Some<Double>(d4));
        double d5 = (Double)this.velocity.get() + d4 * d;
        if (this.changedDirection(d5, (Double)this.velocity.get())) {
            d5 = 0.0;
        }
        if (d5 > 20.0) {
            d5 = 20.0;
        }
        if (d5 < -20.0) {
            d5 = -20.0;
        }
        this.velocity.set(d5);
        this.position.set((Double)this.position.get() + (Double)this.velocity.get() * d);
        this.speed.set(new Option.Some<Double>(Math.abs((Double)this.velocity.get())));
        this._speedValue.set((Double)this.velocity.get() >= 20.0 ? SpeedValue.RIGHT_SPEED_EXCEEDED : ((Double)this.velocity.get() <= -20.0 ? SpeedValue.LEFT_SPEED_EXCEEDED : SpeedValue.WITHIN_ALLOWED_RANGE));
        if (this._speedValue.get() != SpeedValue.WITHIN_ALLOWED_RANGE) {
            this.lastOutOfRange = new Pair<Long, SpeedValue>(System.currentTimeMillis(), this._speedValue.get());
            this.speedValue.set(this._speedValue.get());
        }
    }

    private boolean changedDirection(double d, double d2) {
        return this.sign(d) == Sign.NEGATIVE && this.sign(d2) == Sign.POSITIVE || this.sign(d2) == Sign.NEGATIVE && this.sign(d) == Sign.POSITIVE;
    }

    private Sign sign(Double d) {
        return d < 0.0 ? Sign.NEGATIVE : (d > 0.0 ? Sign.POSITIVE : Sign.ZERO);
    }

    double updateForces() {
        double d = (Double)this.appliedForce.get();
        double d2 = this.getFrictionForce(d);
        this.frictionForce.set(d2);
        double d3 = d2 + d;
        this.sumOfForces.set(d3);
        return d3;
    }

    private double getFrictionForce(double d) {
        double d2 = 10.0;
        if (!this.friction) {
            return 0.0;
        }
        double d3 = Math.abs((Double)this.frictionValue.get()) * (double)MathUtil.getSign(d) * this.massOfObjectsOnSkateboard.get() * d2;
        if (Math.abs((Double)this.velocity.get()) <= 1.0E-12 && Math.abs(d3) > Math.abs(d)) {
            d3 = d;
        } else if (Math.abs((Double)this.velocity.get()) > 1.0E-12) {
            d3 = (double)MathUtil.getSign((Double)this.velocity.get()) * (Double)this.frictionValue.get() * this.massOfObjectsOnSkateboard.get() * d2;
        }
        return -d3;
    }

    public void clockStepped() {
        boolean bl;
        boolean bl2 = this.lastOutOfRange != null && System.currentTimeMillis() - (Long)this.lastOutOfRange._1 > 1000L;
        boolean bl3 = bl = this._speedValue.get() == SpeedValue.WITHIN_ALLOWED_RANGE && this.lastOutOfRange == null;
        if (bl2 || bl) {
            this.lastOutOfRange = null;
            this.speedValue.set(this._speedValue.get());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Sign
    extends Enum<Sign> {
        public static final /* enum */ Sign POSITIVE = new Sign();
        public static final /* enum */ Sign NEGATIVE = new Sign();
        public static final /* enum */ Sign ZERO = new Sign();
        private static final /* synthetic */ Sign[] $VALUES;

        public static Sign[] values() {
            return (Sign[])$VALUES.clone();
        }

        static {
            $VALUES = new Sign[]{POSITIVE, NEGATIVE, ZERO};
        }
    }
}

