/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forcesandmotionbasics.tugofwar;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.PhetPText;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import javax.swing.Timer;

class FlagNode
extends PNode {
    private final Timer timer;

    public FlagNode(Color color, String string) {
        final PhetPPath phetPPath = new PhetPPath(this.createPath(), color, new BasicStroke(2.0f), Color.black);
        this.addChild(phetPPath);
        PhetPText phetPText = new PhetPText(string, new PhetFont(32, true)){
            {
                this.setTextPaint(Color.white);
            }
        };
        double d = phetPText.getFullWidth();
        if (d > 165.0) {
            phetPText.scale(165.0 / d);
        }
        phetPText.centerFullBoundsOnPoint(phetPPath.getFullBounds().getCenterX(), phetPPath.getFullBounds().getCenterY());
        this.addChild(phetPText);
        this.timer = new Timer(20, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                phetPPath.setPathTo(FlagNode.this.createPath());
            }
        });
        this.timer.start();
    }

    private GeneralPath createPath() {
        double d = (double)System.currentTimeMillis() / 1000.0;
        GeneralPath generalPath = new GeneralPath();
        float f = (float)(7.0 * Math.sin(d * 6.0));
        float f2 = (float)(2.0 * Math.sin(d * 5.0)) + 10.0f;
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.curveTo(58.0f + f2, 25.0f + f, 116.0f + f2, -25.0f - f, 175.0f + f2, f / 2.0f);
        generalPath.lineTo(175.0f + f2, 75.0f + f / 2.0f);
        generalPath.curveTo(116.0f + f2, 50.0f - f, 58.0f + f2, 100.0f + f, 0.0f, 75.0f);
        generalPath.lineTo(0.0f, 0.0f);
        generalPath.closePath();
        return generalPath;
    }

    public void dispose() {
        this.timer.stop();
    }
}

