/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forcesandmotionbasics.tugofwar;

import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.forcesandmotionbasics.tugofwar.PullerNode;
import edu.umd.cs.piccolo.PNode;
import fj.Effect;
import fj.F;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;

public class KnotNode
extends PNode {
    public static final F<KnotNode, Boolean> _free = new F<KnotNode, Boolean>(){

        @Override
        public Boolean f(KnotNode knotNode) {
            return knotNode.pullerNode == null;
        }
    };
    private PullerNode pullerNode;
    private final PhetPPath path;
    private final Color color = PullerNode.TRANSPARENT;
    public static final Effect<KnotNode> _removeHighlight = new Effect<KnotNode>(){

        @Override
        public void e(KnotNode knotNode) {
            knotNode.setHighlighted(false);
        }
    };
    public static final F<KnotNode, Double> _force = new F<KnotNode, Double>(){

        @Override
        public Double f(KnotNode knotNode) {
            return knotNode.pullerNode == null ? 0.0 : knotNode.pullerNode.getForce();
        }
    };

    public KnotNode(final Double d, final Rectangle2D rectangle2D) {
        double d2 = 30.0;
        this.path = new PhetPPath(new Ellipse2D.Double(-d2 / 2.0, -d2 / 2.0, d2, d2), new BasicStroke(2.0f), PullerNode.TRANSPARENT){
            {
                super(shape, stroke, paint);
                this.setOffset(rectangle2D.getX() + d + 1.0, rectangle2D.getCenterY() - this.getFullBounds().getHeight() / 2.0 + 17.0);
            }
        };
        this.addChild(this.path);
    }

    public void setHighlighted(boolean bl) {
        this.path.setStrokePaint(bl ? Color.yellow : this.color);
    }

    public void setPullerNode(PullerNode pullerNode) {
        this.pullerNode = pullerNode;
    }

    public PullerNode getPullerNode() {
        return this.pullerNode;
    }
}

