/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forcesandmotionbasics.tugofwar;

import edu.colorado.phet.common.phetcommon.audio.PhetAudioClip;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ModelActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ModelComponentTypes;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.util.functionaljava.FJUtils;
import edu.colorado.phet.common.phetcommon.view.Dimension2DDouble;
import edu.colorado.phet.common.phetcommon.view.controls.PropertyCheckBox;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.common.piccolophet.nodes.ControlPanelNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.ResetAllButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.TextButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.background.SkyNode;
import edu.colorado.phet.common.piccolophet.nodes.layout.HBox;
import edu.colorado.phet.common.piccolophet.nodes.layout.VBox;
import edu.colorado.phet.forcesandmotionbasics.ForcesAndMotionBasicsApplication;
import edu.colorado.phet.forcesandmotionbasics.ForcesAndMotionBasicsResources;
import edu.colorado.phet.forcesandmotionbasics.ForcesAndMotionBasicsSimSharing;
import edu.colorado.phet.forcesandmotionbasics.common.AbstractForcesAndMotionBasicsCanvas;
import edu.colorado.phet.forcesandmotionbasics.tugofwar.CaretNode;
import edu.colorado.phet.forcesandmotionbasics.tugofwar.Cart;
import edu.colorado.phet.forcesandmotionbasics.tugofwar.FlagNode;
import edu.colorado.phet.forcesandmotionbasics.tugofwar.ForcesNode;
import edu.colorado.phet.forcesandmotionbasics.tugofwar.ImageButtonNodeWithText;
import edu.colorado.phet.forcesandmotionbasics.tugofwar.KnotNode;
import edu.colorado.phet.forcesandmotionbasics.tugofwar.PullerContext;
import edu.colorado.phet.forcesandmotionbasics.tugofwar.PullerNode;
import edu.colorado.phet.forcesandmotionbasics.tugofwar.RopeImageMetrics;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.pswing.PSwing;
import fj.Effect;
import fj.F;
import fj.F2;
import fj.data.List;
import fj.data.Option;
import fj.function.Doubles;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TugOfWarCanvas
extends AbstractForcesAndMotionBasicsCanvas
implements PullerContext {
    private final List<KnotNode> blueKnots;
    private final List<KnotNode> redKnots;
    private final ForcesNode forcesNode;
    private final ArrayList<VoidFunction0> forceListeners = new ArrayList();
    private final PImage cartNode;
    private final Property<Boolean> showSumOfForces = new Property<Boolean>(false);
    private final Property<Boolean> showValues = new Property<Boolean>(false);
    private final Property<Boolean> sound = new Property<Boolean>(true);
    private final Property<Mode> mode = new Property<Mode>(Mode.WAITING);
    private final Cart cart = new Cart();
    private final ArrayList<PullerNode> pullers = new ArrayList();
    private final PImage rope;
    private final double initialRopeX;
    private final ArrayList<VoidFunction0> cartPositionListeners = new ArrayList();
    private final ImageButtonNodeWithText pauseButton;
    private final ImageButtonNodeWithText goButton;
    private final PNode knotLayer;
    private final PNode flagLayer;

    public TugOfWarCanvas(final Resettable resettable, IClock iClock) {
        this.setBackground(ForcesAndMotionBasicsApplication.BROWN);
        this.addChild(new SkyNode(ModelViewTransform.createIdentity(), new Rectangle2D.Double(-5000.0, -4548.0, 10000.0, 5000.0), 452.0, SkyNode.DEFAULT_TOP_COLOR, SkyNode.DEFAULT_BOTTOM_COLOR));
        HBox hBox = new HBox(-4.0, new PImage(ForcesAndMotionBasicsResources.Images.GRASS), new PImage(ForcesAndMotionBasicsResources.Images.GRASS), new PImage(ForcesAndMotionBasicsResources.Images.GRASS));
        ((PNode)hBox).setOffset(-hBox.getFullBounds().getWidth() / 2.0, 450.0);
        this.addChild(hBox);
        PropertyCheckBox propertyCheckBox = new PropertyCheckBox(ForcesAndMotionBasicsSimSharing.UserComponents.sumOfForcesCheckBox, ForcesAndMotionBasicsResources.Strings.SUM_OF_FORCES, this.showSumOfForces){
            {
                this.setFont(AbstractForcesAndMotionBasicsCanvas.DEFAULT_FONT);
            }
        };
        PropertyCheckBox propertyCheckBox2 = new PropertyCheckBox(ForcesAndMotionBasicsSimSharing.UserComponents.valuesCheckBox, ForcesAndMotionBasicsResources.Strings.VALUES, this.showValues){
            {
                this.setFont(AbstractForcesAndMotionBasicsCanvas.DEFAULT_FONT);
            }
        };
        PropertyCheckBox propertyCheckBox3 = new PropertyCheckBox(ForcesAndMotionBasicsSimSharing.UserComponents.soundCheckBox, ForcesAndMotionBasicsResources.Strings.SOUND, this.sound){
            {
                this.setFont(AbstractForcesAndMotionBasicsCanvas.DEFAULT_FONT);
            }
        };
        final ControlPanelNode controlPanelNode = new ControlPanelNode((PNode)new VBox(2.0, VBox.LEFT_ALIGNED, new PSwing(propertyCheckBox), new PSwing(propertyCheckBox2), new PSwing(propertyCheckBox3)), new Color(227, 233, 128), new BasicStroke(2.0f), Color.black);
        controlPanelNode.setOffset(TugOfWarCanvas.STAGE_SIZE.width - controlPanelNode.getFullWidth() - 10.0, 10.0);
        this.addChild(controlPanelNode);
        this.addChild(new ResetAllButtonNode(new Resettable(){

            public void reset() {
                resettable.reset();
            }
        }, this, DEFAULT_FONT, Color.black, Color.orange){
            {
                super(resettable, component, font, color, color2);
                this.setOffset(controlPanelNode.getFullBounds().getCenterX() - this.getFullBounds().getWidth() / 2.0, controlPanelNode.getMaxY() + 10.0);
                this.setConfirmationEnabled(false);
            }
        });
        this.cartNode = new PImage(ForcesAndMotionBasicsResources.Images.CART);
        this.cartNode.setOffset(TugOfWarCanvas.STAGE_SIZE.width / 2.0 - this.cartNode.getFullBounds().getWidth() / 2.0, 452.0 - this.cartNode.getFullBounds().getHeight() + 4.0);
        this.rope = new PImage(ForcesAndMotionBasicsResources.Images.ROPE);
        this.initialRopeX = TugOfWarCanvas.STAGE_SIZE.width / 2.0 - this.rope.getFullBounds().getWidth() / 2.0;
        this.rope.setOffset(this.initialRopeX, this.cartNode.getFullBounds().getCenterY() - this.rope.getFullBounds().getHeight() / 2.0);
        this.blueKnots = RopeImageMetrics.blueKnots.map(new F<Double, KnotNode>(){

            @Override
            public KnotNode f(Double d) {
                return new KnotNode(d, TugOfWarCanvas.this.rope.getFullBounds());
            }
        });
        this.redKnots = RopeImageMetrics.redKnots.map(new F<Double, KnotNode>(){

            @Override
            public KnotNode f(Double d) {
                return new KnotNode(d, TugOfWarCanvas.this.rope.getFullBounds());
            }
        });
        this.knotLayer = new PNode(){
            {
                this.addChildren(TugOfWarCanvas.this.blueKnots.append(TugOfWarCanvas.this.redKnots).toCollection());
            }
        };
        this.addChild(this.knotLayer);
        this.addChild(this.rope);
        this.addChild(this.cartNode);
        double d = -6.0;
        Vector2D vector2D = Vector2D.v(88.38995568685374, 489.0 + d);
        Vector2D vector2D2 = Vector2D.v(155.66912850812423, 517.0 + d);
        Vector2D vector2D3 = Vector2D.v(215.9527326440175, 558.0 + d);
        Vector2D vector2D4 = Vector2D.v(263.1610044313148, 558.0 + d);
        PullerNode pullerNode = this.puller(ForcesAndMotionBasicsSimSharing.UserComponents.largeBluePuller, PullerColor.BLUE, PullerSize.LARGE, 0.75, vector2D);
        this.addPuller(pullerNode);
        this.addPuller(this.puller(ForcesAndMotionBasicsSimSharing.UserComponents.mediumBluePuller, PullerColor.BLUE, PullerSize.MEDIUM, 0.75, vector2D2));
        this.addPuller(this.puller(ForcesAndMotionBasicsSimSharing.UserComponents.smallBluePuller1, PullerColor.BLUE, PullerSize.SMALL, 0.75, vector2D3));
        this.addPuller(this.puller(ForcesAndMotionBasicsSimSharing.UserComponents.smallBluePuller2, PullerColor.BLUE, PullerSize.SMALL, 0.75, vector2D4));
        double d2 = pullerNode.getFullBounds().getWidth();
        this.addPuller(this.puller(ForcesAndMotionBasicsSimSharing.UserComponents.largeRedPuller, PullerColor.RED, PullerSize.LARGE, 0.75, this.reflect(vector2D, d2)));
        this.addPuller(this.puller(ForcesAndMotionBasicsSimSharing.UserComponents.mediumRedPuller, PullerColor.RED, PullerSize.MEDIUM, 0.75, this.reflect(vector2D2, d2)));
        this.addPuller(this.puller(ForcesAndMotionBasicsSimSharing.UserComponents.smallRedPuller1, PullerColor.RED, PullerSize.SMALL, 0.75, this.reflect(vector2D3, d2)));
        this.addPuller(this.puller(ForcesAndMotionBasicsSimSharing.UserComponents.smallRedPuller2, PullerColor.RED, PullerSize.SMALL, 0.75, this.reflect(vector2D4, d2)));
        PhetPPath phetPPath = new PhetPPath(this.getBounds(PullerNode._isBlue), ForcesAndMotionBasicsApplication.TOOLBOX_COLOR, new BasicStroke(1.0f), Color.black);
        this.addChild(phetPPath);
        PhetPPath phetPPath2 = new PhetPPath(this.getBounds(PullerNode._isRed), ForcesAndMotionBasicsApplication.TOOLBOX_COLOR, new BasicStroke(1.0f), Color.black);
        this.addChild(phetPPath2);
        phetPPath.moveToBack();
        phetPPath2.moveToBack();
        this.forcesNode = new ForcesNode();
        this.addChild(this.forcesNode);
        this.goButton = new ImageButtonNodeWithText(ForcesAndMotionBasicsSimSharing.UserComponents.goButton, ForcesAndMotionBasicsResources.Images.GO_UP, ForcesAndMotionBasicsResources.Images.GO_HOVER, ForcesAndMotionBasicsResources.Images.GO_PRESSED, ForcesAndMotionBasicsResources.Strings.GO, new VoidFunction0(){

            public void apply() {
                TugOfWarCanvas.this.mode.set(Mode.GOING);
                TugOfWarCanvas.this.pauseButton.hover();
            }
        }){
            {
                this.setOffset(TugOfWarCanvas.this.getButtonLocation(this));
                VoidFunction0 voidFunction02 = new VoidFunction0(){

                    public void apply() {
                        boolean bl = TugOfWarCanvas.this.redKnots.append(TugOfWarCanvas.this.blueKnots).filter(new F<KnotNode, Boolean>(){

                            @Override
                            public Boolean f(KnotNode knotNode) {
                                return knotNode.getPullerNode() != null;
                            }
                        }).length() > 0 && (TugOfWarCanvas.this.mode.get() == Mode.WAITING || TugOfWarCanvas.this.mode.get() == Mode.PAUSED);
                        this.setVisible(bl);
                        this.setChildrenPickable(bl);
                    }
                };
                TugOfWarCanvas.this.forceListeners.add(voidFunction02);
                voidFunction02.apply();
            }
        };
        this.addChild(this.goButton);
        this.pauseButton = new ImageButtonNodeWithText(ForcesAndMotionBasicsSimSharing.UserComponents.stopButton, ForcesAndMotionBasicsResources.Images.STOP_UP, ForcesAndMotionBasicsResources.Images.STOP_HOVER, ForcesAndMotionBasicsResources.Images.STOP_PRESSED, ForcesAndMotionBasicsResources.Strings.PAUSE, new VoidFunction0(){

            public void apply() {
                TugOfWarCanvas.this.mode.set(Mode.PAUSED);
                TugOfWarCanvas.this.goButton.hover();
            }
        }){
            {
                this.setOffset(TugOfWarCanvas.this.getButtonLocation(this));
                TugOfWarCanvas.this.mode.addObserver(new VoidFunction1<Mode>(){

                    @Override
                    public void apply(Mode mode) {
                        boolean bl = mode == Mode.GOING;
                        this.setVisible(bl);
                        this.setChildrenPickable(bl);
                    }
                });
            }
        };
        this.addChild(this.pauseButton);
        this.addChild(new TextButtonNode(ForcesAndMotionBasicsResources.Strings.RETURN, DEFAULT_FONT, Color.orange){
            {
                this.setUserComponent(ForcesAndMotionBasicsSimSharing.UserComponents.returnButton);
                this.setOffset(TugOfWarCanvas.this.pauseButton.getFullBounds().getCenterX() - this.getFullBounds().getWidth() / 2.0, TugOfWarCanvas.this.pauseButton.getFullBounds().getMaxY() + 10.0);
                SimpleObserver simpleObserver = new SimpleObserver(){

                    public void update() {
                        Mode mode = (Mode)((Object)TugOfWarCanvas.this.mode.get());
                        boolean bl = mode == Mode.GOING || mode == Mode.COMPLETE || mode == Mode.WAITING && !TugOfWarCanvas.this.isCartInCenter() || mode == Mode.PAUSED;
                        this.setVisible(bl);
                        this.setPickable(bl);
                        this.setChildrenPickable(bl);
                    }
                };
                TugOfWarCanvas.this.mode.addObserver(simpleObserver);
                ((TugOfWarCanvas)TugOfWarCanvas.this).cart.position.addObserver(simpleObserver);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        TugOfWarCanvas.this.restart();
                    }
                });
            }
        });
        this.mode.addObserver(new VoidFunction1<Mode>(){

            @Override
            public void apply(Mode mode) {
                TugOfWarCanvas.this.updateForceListeners();
            }
        });
        iClock.addClockListener(new ClockAdapter(){

            public void simulationTimeChanged(ClockEvent clockEvent) {
                if (TugOfWarCanvas.this.mode.get() == Mode.GOING) {
                    double d = TugOfWarCanvas.this.cart.getPosition();
                    double d2 = clockEvent.getSimulationTimeChange();
                    double d3 = TugOfWarCanvas.this.getSumOfForces() / (((TugOfWarCanvas)TugOfWarCanvas.this).cart.weight + TugOfWarCanvas.this.getAttachedPullers().map(PullerNode._weight).foldLeft(Doubles.add, Double.valueOf(0.0)));
                    TugOfWarCanvas.this.cart.stepInTime(d2, d3);
                    double d4 = TugOfWarCanvas.this.cart.getPosition() - d;
                    TugOfWarCanvas.this.moveSystem(d4);
                    TugOfWarCanvas.this.notifyCartPositionListeners();
                    if (TugOfWarCanvas.this.cart.getPosition() > 180.0 || TugOfWarCanvas.this.cart.getPosition() < -180.0) {
                        TugOfWarCanvas.this.mode.set(Mode.COMPLETE);
                        if (TugOfWarCanvas.this.cart.getPosition() > 180.0) {
                            TugOfWarCanvas.this.addFlagNode(new FlagNode(Color.red, ForcesAndMotionBasicsResources.Strings.RED_WINS), "red");
                        } else {
                            TugOfWarCanvas.this.addFlagNode(new FlagNode(Color.blue, ForcesAndMotionBasicsResources.Strings.BLUE_WINS), "blue");
                        }
                    }
                }
            }
        });
        this.addChild(new CaretNode(){
            {
                this.setOffset(AbstractForcesAndMotionBasicsCanvas.STAGE_SIZE.width / 2.0, 461.0);
            }
        });
        this.showSumOfForces.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                TugOfWarCanvas.this.updateForceArrows();
            }
        });
        this.showValues.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                TugOfWarCanvas.this.updateForceArrows();
            }
        });
        this.flagLayer = new PNode();
        this.addChild(this.flagLayer);
    }

    private void addFlagNode(FlagNode flagNode, String string) {
        flagNode.setTransparency(0.0f);
        this.flagLayer.addChild(flagNode);
        flagNode.setOffset(TugOfWarCanvas.STAGE_SIZE.width / 2.0 - flagNode.getFullBounds().getWidth() / 2.0, 0.0 - flagNode.getFullBounds().getHeight());
        flagNode.animateToTransparency(1.0f, 200L);
        flagNode.animateToPositionScaleRotation(TugOfWarCanvas.STAGE_SIZE.width / 2.0 - flagNode.getFullBounds().getWidth() / 2.0, 10.0, 1.0, 0.0, 200L);
        if (this.sound.get().booleanValue()) {
            new PhetAudioClip("forces-and-motion-basics/audio/golf-clap.wav").play();
        }
        SimSharingManager.sendModelMessage(ForcesAndMotionBasicsSimSharing.ModelComponents.tugOfWarGame, ModelComponentTypes.modelElement, ModelActions.ended, ParameterSet.parameterSet((IParameterKey)ForcesAndMotionBasicsSimSharing.ParameterKeys.winningTeam, string));
    }

    private Shape getBounds(F<PullerNode, Boolean> f) {
        PBounds pBounds = List.iterableList(this.pullers).filter(f).map(PullerNode._getFullBounds).foldLeft(new F2<PBounds, PBounds, PBounds>(){

            @Override
            public PBounds f(PBounds pBounds, PBounds pBounds2) {
                if (pBounds == null) {
                    return pBounds2;
                }
                if (pBounds2 == null) {
                    return pBounds;
                }
                return new PBounds(pBounds.createUnion(pBounds2));
            }
        }, null);
        Rectangle2D rectangle2D = RectangleUtils.expand(pBounds, 15.0, 10.0);
        return new RoundRectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight(), 20.0, 20.0);
    }

    private void notifyCartPositionListeners() {
        for (VoidFunction0 voidFunction0 : this.cartPositionListeners) {
            voidFunction0.apply();
        }
    }

    private void moveSystem(final double d) {
        this.cartNode.translate(d, 0.0);
        this.rope.translate(d, 0.0);
        this.knotLayer.translate(d, 0.0);
        this.getAttachedPullers().foreach(new Effect<PullerNode>(){

            @Override
            public void e(PullerNode pullerNode) {
                pullerNode.translate(d / pullerNode.getScale(), 0.0);
            }
        });
    }

    private void restart() {
        this.mode.set(Mode.WAITING);
        this.cart.restart();
        double d = this.rope.getOffset().getX() - this.initialRopeX;
        this.moveSystem(-d);
        this.updateForceListeners();
        this.notifyCartPositionListeners();
        for (Object e : this.flagLayer.getChildrenReference()) {
            if (!(e instanceof FlagNode)) continue;
            FlagNode flagNode = (FlagNode)e;
            flagNode.dispose();
        }
        this.flagLayer.removeAllChildren();
    }

    private void addPuller(PullerNode pullerNode) {
        this.addChild(pullerNode);
        this.pullers.add(pullerNode);
    }

    List<PullerNode> getAttachedPullers() {
        return this.blueKnots.append(this.redKnots).bind(new F<KnotNode, List<PullerNode>>(){

            @Override
            public List<PullerNode> f(KnotNode knotNode) {
                return knotNode.getPullerNode() == null ? List.nil() : List.single(knotNode.getPullerNode());
            }
        });
    }

    private Point2D getButtonLocation(PNode pNode) {
        return new Point2D.Double(TugOfWarCanvas.STAGE_SIZE.width / 2.0 - pNode.getFullBounds().getWidth() / 2.0, this.cartNode.getFullBounds().getMaxY() + 20.0);
    }

    private Vector2D reflect(Vector2D vector2D, double d) {
        double d2 = TugOfWarCanvas.STAGE_SIZE.width / 2.0 - vector2D.x;
        double d3 = TugOfWarCanvas.STAGE_SIZE.width / 2.0 + d2 - d;
        return new Vector2D(d3, vector2D.y);
    }

    PullerNode puller(IUserComponent iUserComponent, PullerColor pullerColor, PullerSize pullerSize, double d, Vector2D vector2D) {
        return new PullerNode(iUserComponent, pullerColor, pullerSize, d, vector2D, this, this.mode);
    }

    @Override
    public void drag(PullerNode pullerNode) {
        List<KnotNode> list = pullerNode.color == PullerColor.BLUE ? this.blueKnots : this.redKnots;
        list.foreach(KnotNode._removeHighlight);
        Option<KnotNode> option = this.getAttachNode(pullerNode);
        option.foreach(new Effect<KnotNode>(){

            @Override
            public void e(KnotNode knotNode) {
                knotNode.setHighlighted(true);
            }
        });
    }

    @Override
    public void endDrag(PullerNode pullerNode) {
        this.blueKnots.append(this.redKnots).foreach(KnotNode._removeHighlight);
        Option<KnotNode> option = this.getAttachNode(pullerNode);
        if (option.isSome()) {
            Point2D point2D = pullerNode.getGlobalAttachmentPoint();
            Point2D point2D2 = option.some().getGlobalFullBounds().getCenter2D();
            Vector2D vector2D = new Vector2D(point2D, point2D2);
            Dimension2D dimension2D = this.rootNode.globalToLocal(new Dimension2DDouble(vector2D.x, vector2D.y));
            pullerNode.animateToPositionScaleRotation(pullerNode.getOffset().getX() + dimension2D.getWidth(), pullerNode.getOffset().getY() + dimension2D.getHeight(), pullerNode.scale, 0.0, this.mode.get() == Mode.GOING ? 0L : 300L);
            option.some().setPullerNode(pullerNode);
            pullerNode.setKnot(option.some());
            this.updateForceListeners();
        } else {
            this.detach(pullerNode);
            pullerNode.animateHome();
        }
    }

    private void detach(PullerNode pullerNode) {
        KnotNode knotNode = pullerNode.getKnot();
        if (knotNode != null) {
            knotNode.setPullerNode(null);
        }
        pullerNode.setKnot(null);
        this.updateForceListeners();
    }

    private void updateForceListeners() {
        this.updateForceArrows();
        for (VoidFunction0 voidFunction0 : this.forceListeners) {
            voidFunction0.apply();
        }
        SimSharingManager.sendModelMessage(ForcesAndMotionBasicsSimSharing.ModelComponents.forceModel, ModelComponentTypes.modelElement, ModelActions.changed, ParameterSet.parameterSet((IParameterKey)ForcesAndMotionBasicsSimSharing.ParameterKeys.sumOfForces, this.getSumOfForces()));
    }

    private void updateForceArrows() {
        this.forcesNode.setForces(this.mode.get() == Mode.PAUSED || this.mode.get() == Mode.WAITING || this.mode.get() == Mode.COMPLETE, this.getLeftForce(), this.getRightForce(), this.showSumOfForces.get(), this.showValues.get());
    }

    private double getRightForce() {
        return this.redKnots.map(KnotNode._force).foldLeft(Doubles.add, Double.valueOf(0.0));
    }

    private double getLeftForce() {
        return -this.blueKnots.map(KnotNode._force).foldLeft(Doubles.add, Double.valueOf(0.0)).doubleValue();
    }

    private double getSumOfForces() {
        return this.getRightForce() + this.getLeftForce();
    }

    @Override
    public void startDrag(PullerNode pullerNode) {
        this.detach(pullerNode);
    }

    public boolean isCartInCenter() {
        return Math.abs(this.cart.getPosition()) < 1.0;
    }

    @Override
    public void addCartPositionChangeListener(VoidFunction0 voidFunction0) {
        this.cartPositionListeners.add(voidFunction0);
    }

    private Option<KnotNode> getAttachNode(final PullerNode pullerNode) {
        List<KnotNode> list = pullerNode.color == PullerColor.BLUE ? this.blueKnots : this.redKnots;
        List<KnotNode> list2 = list.filter(KnotNode._free).filter(new F<KnotNode, Boolean>(){

            @Override
            public Boolean f(KnotNode knotNode) {
                return TugOfWarCanvas.this.knotPullerDistance(knotNode, pullerNode) < 80.0;
            }
        });
        if (list2.length() > 0) {
            KnotNode knotNode = list2.minimum(FJUtils.ord(new F<KnotNode, Double>(){

                @Override
                public Double f(KnotNode knotNode) {
                    return TugOfWarCanvas.this.knotPullerDistance(knotNode, pullerNode);
                }
            }));
            return Option.some(knotNode);
        }
        return Option.none();
    }

    private double knotPullerDistance(KnotNode knotNode, PullerNode pullerNode) {
        return knotNode.getGlobalFullBounds().getCenter2D().distance(pullerNode.getGlobalAttachmentPoint());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode WAITING = new Mode();
        public static final /* enum */ Mode GOING = new Mode();
        public static final /* enum */ Mode PAUSED = new Mode();
        public static final /* enum */ Mode COMPLETE = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        static {
            $VALUES = new Mode[]{WAITING, GOING, PAUSED, COMPLETE};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PullerColor
    extends Enum<PullerColor> {
        public static final /* enum */ PullerColor BLUE = new PullerColor();
        public static final /* enum */ PullerColor RED = new PullerColor();
        private static final /* synthetic */ PullerColor[] $VALUES;

        public static PullerColor[] values() {
            return (PullerColor[])$VALUES.clone();
        }

        static {
            $VALUES = new PullerColor[]{BLUE, RED};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PullerSize
    extends Enum<PullerSize> {
        public static final /* enum */ PullerSize SMALL = new PullerSize();
        public static final /* enum */ PullerSize MEDIUM = new PullerSize();
        public static final /* enum */ PullerSize LARGE = new PullerSize();
        private static final /* synthetic */ PullerSize[] $VALUES;

        public static PullerSize[] values() {
            return (PullerSize[])$VALUES.clone();
        }

        static {
            $VALUES = new PullerSize[]{SMALL, MEDIUM, LARGE};
        }
    }
}

