/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.pswing;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import edu.umd.cs.piccolox.pswing.PSwingRepaintManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.RepaintManager;

public class PSwing
extends PNode
implements PropertyChangeListener,
Serializable {
    private static final PBounds TEMP_REPAINT_BOUNDS2 = new PBounds();
    private double greekThreshold = 0.3;
    private JComponent component = null;
    private double minFontSize = Double.MAX_VALUE;
    private Stroke defaultStroke = new BasicStroke();
    private static final Font DEFAULT_FONT = new Font("Serif", 0, 12);
    private PSwingCanvas canvas;
    private final ArrayList listeningTo = new ArrayList();
    private final PropertyChangeListener parentListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PNode pNode = (PNode)propertyChangeEvent.getNewValue();
            this.clearListeners((PNode)propertyChangeEvent.getOldValue());
            if (pNode == null) {
                PSwing.this.updateCanvas(null);
            } else {
                PSwing.this.listenForCanvas(pNode);
            }
        }

        private void clearListeners(PNode pNode) {
            if (pNode != null && PSwing.this.isListeningTo(pNode)) {
                pNode.removePropertyChangeListener("parent", PSwing.this.parentListener);
                PSwing.this.listeningTo.remove(pNode);
                this.clearListeners(pNode.getParent());
            }
        }
    };
    private final ContainerListener doubleBufferRemover = new ContainerAdapter(){

        public void componentAdded(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (component != null && component instanceof JComponent) {
                this.disableDoubleBuffering((JComponent)component);
            }
        }

        private void disableDoubleBuffering(JComponent jComponent) {
            jComponent.setDoubleBuffered(false);
            for (int i = 0; i < jComponent.getComponentCount(); ++i) {
                Component component = jComponent.getComponent(i);
                if (!(component instanceof JComponent)) continue;
                this.disableDoubleBuffering((JComponent)component);
            }
        }
    };

    public PSwing(JComponent jComponent) {
        this.component = jComponent;
        jComponent.putClientProperty("PSwing", this);
        this.initializeComponent(jComponent);
        jComponent.revalidate();
        this.updateBounds();
        this.listenForCanvas(this);
    }

    public void updateBounds() {
        if (this.componentNeedsResizing()) {
            this.updateComponentSize();
        }
        this.setBounds(0.0, 0.0, this.component.getPreferredSize().width, this.component.getPreferredSize().height);
    }

    private void updateComponentSize() {
        this.component.setBounds(0, 0, this.component.getPreferredSize().width, this.component.getPreferredSize().height);
    }

    private boolean componentNeedsResizing() {
        return this.component.getWidth() != this.component.getPreferredSize().width || this.component.getHeight() != this.component.getPreferredSize().height;
    }

    public void paint(PPaintContext pPaintContext) {
        if (this.componentNeedsResizing()) {
            this.updateComponentSize();
            this.component.validate();
        }
        Graphics2D graphics2D = pPaintContext.getGraphics();
        Stroke stroke = graphics2D.getStroke();
        Font font = graphics2D.getFont();
        graphics2D.setStroke(this.defaultStroke);
        graphics2D.setFont(DEFAULT_FONT);
        if (this.shouldRenderGreek(pPaintContext)) {
            this.paintAsGreek(graphics2D);
        } else {
            this.paint(graphics2D);
        }
        graphics2D.setStroke(stroke);
        graphics2D.setFont(font);
    }

    protected boolean shouldRenderGreek(PPaintContext pPaintContext) {
        return pPaintContext.getScale() < this.greekThreshold || this.minFontSize * pPaintContext.getScale() < 0.5;
    }

    public void paintAsGreek(Graphics2D graphics2D) {
        Color color = graphics2D.getColor();
        if (this.component.getBackground() != null) {
            graphics2D.setColor(this.component.getBackground());
        }
        graphics2D.fill(this.getBounds());
        if (this.component.getForeground() != null) {
            graphics2D.setColor(this.component.getForeground());
        }
        graphics2D.draw(this.getBounds());
        graphics2D.setColor(color);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.component.isVisible() != bl) {
            this.component.setVisible(bl);
        }
    }

    public void paint(Graphics2D graphics2D) {
        if (this.component.getBounds().isEmpty()) {
            return;
        }
        PSwingRepaintManager pSwingRepaintManager = (PSwingRepaintManager)RepaintManager.currentManager(this.component);
        pSwingRepaintManager.lockRepaint(this.component);
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        if (System.getProperty("os.name").startsWith("Mac OS X")) {
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        }
        this.component.paint(graphics2D);
        graphics2D.setRenderingHints(renderingHints);
        pSwingRepaintManager.unlockRepaint(this.component);
    }

    public void repaint(PBounds pBounds) {
        Shape shape = this.getTransform().createTransformedShape(pBounds);
        TEMP_REPAINT_BOUNDS2.setRect(shape.getBounds2D());
        this.repaintFrom(TEMP_REPAINT_BOUNDS2, this);
    }

    public JComponent getComponent() {
        return this.component;
    }

    private void initializeComponent(Component component) {
        if (component.getFont() != null) {
            this.minFontSize = Math.min(this.minFontSize, (double)component.getFont().getSize());
        }
        component.addPropertyChangeListener("font", this);
        if (component instanceof Container) {
            this.initializeChildren((Container)component);
            ((Container)component).addContainerListener(this.doubleBufferRemover);
        }
        if (component instanceof JComponent) {
            ((JComponent)component).setDoubleBuffered(false);
        }
    }

    private void initializeChildren(Container container) {
        Component[] componentArray = container.getComponents();
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                this.initializeComponent(componentArray[i]);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Component component = (Component)propertyChangeEvent.getSource();
        if (component.getFont() != null && this.component.isAncestorOf(component)) {
            this.minFontSize = Math.min(this.minFontSize, (double)component.getFont().getSize());
        }
    }

    private void listenForCanvas(PNode pNode) {
        block0: for (PNode pNode2 = pNode; pNode2 != null; pNode2 = pNode2.getParent()) {
            this.listenToNode(pNode2);
            PNode pNode3 = pNode2;
            if (!(pNode3 instanceof PLayer)) continue;
            PLayer pLayer = (PLayer)pNode3;
            for (int i = 0; i < pLayer.getCameraCount(); ++i) {
                PCamera pCamera = pLayer.getCamera(i);
                if (!(pCamera.getComponent() instanceof PSwingCanvas)) continue;
                this.updateCanvas((PSwingCanvas)pCamera.getComponent());
                continue block0;
            }
        }
    }

    private void listenToNode(PNode pNode) {
        if (!this.isListeningTo(pNode)) {
            this.listeningTo.add(pNode);
            pNode.addPropertyChangeListener("parent", this.parentListener);
        }
    }

    private boolean isListeningTo(PNode pNode) {
        for (int i = 0; i < this.listeningTo.size(); ++i) {
            PNode pNode2 = (PNode)this.listeningTo.get(i);
            if (pNode2 != pNode) continue;
            return true;
        }
        return false;
    }

    private void updateCanvas(PSwingCanvas pSwingCanvas) {
        if (pSwingCanvas == this.canvas) {
            return;
        }
        if (this.canvas != null) {
            this.canvas.removePSwing(this);
        }
        if (pSwingCanvas == null) {
            this.canvas = null;
        } else {
            this.canvas = pSwingCanvas;
            this.canvas.addPSwing(this);
            this.updateBounds();
            this.repaint();
            this.canvas.invalidate();
            this.canvas.revalidate();
            this.canvas.repaint();
        }
    }
}

