/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Bottom;
import fj.Effect;
import fj.Equal;
import fj.F;
import fj.F2;
import fj.Function;
import fj.Hash;
import fj.Ord;
import fj.P;
import fj.P2;
import fj.Show;
import fj.data.Array;
import fj.data.Option;
import fj.data.Stream;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class List<A>
implements Iterable<A> {
    private List() {
    }

    @Override
    public final Iterator<A> iterator() {
        return this.toCollection().iterator();
    }

    public abstract A head();

    public abstract List<A> tail();

    public final int length() {
        return this.foldLeft(new F<Integer, F<A, Integer>>(){

            @Override
            public F<A, Integer> f(final Integer n) {
                return new F<A, Integer>(){

                    @Override
                    public Integer f(A a) {
                        return n + 1;
                    }
                };
            }
        }, Integer.valueOf(0));
    }

    public final boolean isEmpty() {
        return this instanceof Nil;
    }

    public final boolean isNotEmpty() {
        return this instanceof Cons;
    }

    public final Stream<A> toStream() {
        Stream stream = Stream.nil();
        return this.foldRight(new F<A, F<Stream<A>, Stream<A>>>(){

            @Override
            public F<Stream<A>, Stream<A>> f(final A a) {
                return new F<Stream<A>, Stream<A>>(){

                    @Override
                    public Stream<A> f(Stream<A> stream) {
                        return stream.cons(a);
                    }
                };
            }
        }, stream);
    }

    public final List<A> cons(A a) {
        return new Cons<A>(a, this);
    }

    public final <B> List<B> map(F<A, B> f) {
        Buffer<B> buffer = Buffer.empty();
        List<A> list = this;
        while (list.isNotEmpty()) {
            buffer.snoc(f.f(list.head()));
            list = list.tail();
        }
        return buffer.toList();
    }

    public final void foreach(Effect<A> effect) {
        List<A> list = this;
        while (list.isNotEmpty()) {
            effect.e(list.head());
            list = list.tail();
        }
    }

    public final List<A> filter(F<A, Boolean> f) {
        Buffer<A> buffer = Buffer.empty();
        List<A> list = this;
        while (list.isNotEmpty()) {
            A a = list.head();
            if (f.f(a).booleanValue()) {
                buffer.snoc(a);
            }
            list = list.tail();
        }
        return buffer.toList();
    }

    public final <B> List<B> bind(F<A, List<B>> f) {
        Buffer<B> buffer = Buffer.empty();
        List<A> list = this;
        while (list.isNotEmpty()) {
            buffer.append(f.f(list.head()));
            list = list.tail();
        }
        return buffer.toList();
    }

    public final List<A> append(List<A> list) {
        return Buffer.fromList(this).append(list).toList();
    }

    public final <B> B foldRight(F<A, F<B, B>> f, B b) {
        return this.isEmpty() ? b : f.f(this.head()).f(this.tail().foldRight(f, b));
    }

    public final <B> B foldLeft(F<B, F<A, B>> f, B b) {
        B b2 = b;
        List<A> list = this;
        while (!list.isEmpty()) {
            b2 = f.f(b2).f(list.head());
            list = list.tail();
        }
        return b2;
    }

    public final <B> B foldLeft(F2<B, A, B> f2, B b) {
        return this.foldLeft(Function.curry(f2), b);
    }

    public final A foldLeft1(F<A, F<A, A>> f) {
        if (this.isEmpty()) {
            throw Bottom.error("Undefined: foldLeft1 on empty list");
        }
        return this.tail().foldLeft(f, this.head());
    }

    public final List<A> reverse() {
        return this.foldLeft(new F<List<A>, F<A, List<A>>>(){

            @Override
            public F<A, List<A>> f(final List<A> list) {
                return new F<A, List<A>>(){

                    @Override
                    public List<A> f(A a) {
                        return List.cons(a, list);
                    }
                };
            }
        }, List.<A>nil());
    }

    public final A index(int n) {
        if (n < 0 || n > this.length() - 1) {
            throw Bottom.error("index " + n + " out of range on list with length " + this.length());
        }
        List<A> list = this;
        for (int i = 0; i < n; ++i) {
            list = list.tail();
        }
        return list.head();
    }

    public final List<A> take(int n) {
        return n <= 0 || this.isEmpty() ? List.nil() : List.cons(this.head(), this.tail().take(n - 1));
    }

    public final <B, C> List<C> zipWith(List<B> list, F<A, F<B, C>> f) {
        return this.isEmpty() || list.isEmpty() ? List.nil() : List.cons(f.f(this.head()).f(list.head()), this.tail().zipWith(list.tail(), f));
    }

    public final List<P2<A, Integer>> zipIndex() {
        return this.zipWith(List.range(0, this.length()), new F<A, F<Integer, P2<A, Integer>>>(){

            @Override
            public F<Integer, P2<A, Integer>> f(final A a) {
                return new F<Integer, P2<A, Integer>>(){

                    @Override
                    public P2<A, Integer> f(Integer n) {
                        return P.p(a, n);
                    }
                };
            }
        });
    }

    public final List<A> snoc(A a) {
        return Buffer.fromList(this).snoc(a).toList();
    }

    public final boolean exists(F<A, Boolean> f) {
        return this.find(f).isSome();
    }

    public final Option<A> find(F<A, Boolean> f) {
        List<A> list = this;
        while (list.isNotEmpty()) {
            if (f.f(list.head()).booleanValue()) {
                return Option.some(list.head());
            }
            list = list.tail();
        }
        return Option.none();
    }

    public final A minimum(Ord<A> ord) {
        return this.foldLeft1(ord.min);
    }

    public final Collection<A> toCollection() {
        return new AbstractCollection<A>(){

            @Override
            public Iterator<A> iterator() {
                return new Iterator<A>(){
                    private List<A> xs;
                    {
                        this.xs = List.this;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.xs.isNotEmpty();
                    }

                    @Override
                    public A next() {
                        if (this.xs.isEmpty()) {
                            throw new NoSuchElementException();
                        }
                        Object a = this.xs.head();
                        this.xs = this.xs.tail();
                        return a;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return List.this.length();
            }
        };
    }

    public static <A> List<A> list(A ... AArray) {
        return Array.array(AArray).toList();
    }

    public static <A> List<A> nil() {
        return new Nil();
    }

    public static <A> List<A> cons(A a, List<A> list) {
        return new Cons<A>(a, list);
    }

    public static List<Integer> range(int n, int n2) {
        return n >= n2 ? List.nil() : List.cons(n, List.range(n + 1, n2));
    }

    public static <A> List<A> single(A a) {
        return List.cons(a, List.<A>nil());
    }

    public static <A> List<A> iterableList(Iterable<A> iterable) {
        Buffer<A> buffer = Buffer.empty();
        for (A a : iterable) {
            buffer.snoc(a);
        }
        return buffer.toList();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof List)) {
            return false;
        }
        return Equal.listEqual(Equal.anyEqual()).eq(this, (List)object);
    }

    public int hashCode() {
        return Hash.listHash(Hash.anyHash()).hash(this);
    }

    public String toString() {
        return Show.listShow(Show.anyShow()).show(this).foldLeft(new F2<String, Character, String>(){

            @Override
            public String f(String string, Character c) {
                return string + c;
            }
        }, "");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Buffer<A>
    implements Iterable<A> {
        private List<A> start = List.nil();
        private Cons<A> tail;
        private boolean exported;

        @Override
        public Iterator<A> iterator() {
            return this.start.iterator();
        }

        public Buffer<A> snoc(A a) {
            if (this.exported) {
                this.copy();
            }
            Cons<A> cons = new Cons<A>(a, List.nil());
            if (this.tail == null) {
                this.start = cons;
            } else {
                ((Cons)this.tail).tail(cons);
            }
            this.tail = cons;
            return this;
        }

        public Buffer<A> append(List<A> list) {
            List<A> list2 = list;
            while (list2.isNotEmpty()) {
                this.snoc(list2.head());
                list2 = list2.tail();
            }
            return this;
        }

        public List<A> toList() {
            this.exported = !this.start.isEmpty();
            return this.start;
        }

        public static <A> Buffer<A> empty() {
            return new Buffer<A>();
        }

        public static <A> Buffer<A> fromList(List<A> list) {
            Buffer<A> buffer = new Buffer<A>();
            List<A> list2 = list;
            while (list2.isNotEmpty()) {
                buffer.snoc(list2.head());
                list2 = list2.tail();
            }
            return buffer;
        }

        private void copy() {
            Cons<A> cons = this.tail;
            this.start = List.nil();
            this.exported = false;
            for (List<A> list = this.start; list != cons; list = list.tail()) {
                this.snoc(list.head());
            }
            if (cons != null) {
                this.snoc(cons.head());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Cons<A>
    extends List<A> {
        private final A head;
        private List<A> tail;

        Cons(A a, List<A> list) {
            this.head = a;
            this.tail = list;
        }

        @Override
        public A head() {
            return this.head;
        }

        @Override
        public List<A> tail() {
            return this.tail;
        }

        private void tail(List<A> list) {
            this.tail = list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Nil<A>
    extends List<A> {
        private Nil() {
        }

        @Override
        public A head() {
            throw Bottom.error("head on empty list");
        }

        @Override
        public List<A> tail() {
            throw Bottom.error("tail on empty list");
        }
    }
}

