/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Bottom;
import fj.F;
import fj.F2;
import fj.Function;
import fj.Monoid;
import fj.P;
import fj.P1;
import fj.P2;
import fj.data.LazyString;
import fj.data.Option;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Stream<A>
implements Iterable<A> {
    private Stream() {
    }

    @Override
    public final Iterator<A> iterator() {
        return this.toCollection().iterator();
    }

    public abstract A head();

    public abstract P1<Stream<A>> tail();

    public final boolean isEmpty() {
        return this instanceof Nil;
    }

    public final boolean isNotEmpty() {
        return this instanceof Cons;
    }

    public final <B> B foldRight(final F<A, F<P1<B>, B>> f, final B b) {
        return this.isEmpty() ? b : f.f(this.head()).f(new P1<B>(){

            @Override
            public B _1() {
                return Stream.this.tail()._1().foldRight(f, b);
            }
        });
    }

    public final <B> B foldRight(F2<A, P1<B>, B> f2, B b) {
        return this.foldRight(Function.curry(f2), b);
    }

    public final <B> B foldLeft(F<B, F<A, B>> f, B b) {
        B b2 = b;
        Stream<A> stream = this;
        while (!stream.isEmpty()) {
            b2 = f.f(b2).f(stream.head());
            stream = stream.tail()._1();
        }
        return b2;
    }

    public final <B> B foldLeft(F2<B, A, B> f2, B b) {
        return this.foldLeft(Function.curry(f2), b);
    }

    public final Stream<A> intersperse(final A a) {
        return this.isEmpty() ? this : Stream.cons(this.head(), new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return this.prefix(a, Stream.this.tail()._1());
            }

            public Stream<A> prefix(A a2, final Stream<A> stream) {
                return stream.isEmpty() ? stream : Stream.cons(a2, P.p(Stream.cons(stream.head(), new P1<Stream<A>>(){

                    @Override
                    public Stream<A> _1() {
                        return this.prefix(a, stream.tail()._1());
                    }
                })));
            }
        });
    }

    public final <B> Stream<B> map(final F<A, B> f) {
        return this.isEmpty() ? Stream.nil() : Stream.cons(f.f(this.head()), new P1<Stream<B>>(){

            @Override
            public Stream<B> _1() {
                return Stream.this.tail()._1().map(f);
            }
        });
    }

    public final Stream<A> append(final Stream<A> stream) {
        return this.isEmpty() ? stream : Stream.cons(this.head(), new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.this.tail()._1().append(stream);
            }
        });
    }

    public final Stream<A> append(final P1<Stream<A>> p1) {
        return this.isEmpty() ? p1._1() : Stream.cons(this.head(), new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.this.tail()._1().append(p1);
            }
        });
    }

    public final Collection<A> toCollection() {
        return new AbstractCollection<A>(){

            @Override
            public Iterator<A> iterator() {
                return new Iterator<A>(){
                    private Stream<A> xs;
                    {
                        this.xs = Stream.this;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.xs.isNotEmpty();
                    }

                    @Override
                    public A next() {
                        if (this.xs.isEmpty()) {
                            throw new NoSuchElementException();
                        }
                        Object a = this.xs.head();
                        this.xs = this.xs.tail()._1();
                        return a;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return Stream.this.length();
            }
        };
    }

    public final Stream<A> cons(A a) {
        return new Cons<A>(a, new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.this;
            }
        });
    }

    public static String asString(Stream<Character> stream) {
        return LazyString.fromStream(stream).toString();
    }

    public static Stream<Character> fromString(String string) {
        return LazyString.str(string).toStream();
    }

    public final Stream<A> snoc(final P1<A> p1) {
        return this.append(new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.single(p1._1());
            }
        });
    }

    public final Stream<A> take(final int n) {
        return n <= 0 || this.isEmpty() ? Stream.nil() : Stream.cons(this.head(), new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.this.tail()._1().take(n - 1);
            }
        });
    }

    public final Stream<A> drop(int n) {
        Stream<A> stream = this;
        for (int i = 0; stream.isNotEmpty() && i < n; ++i) {
            stream = stream.tail()._1();
        }
        return stream;
    }

    public final int length() {
        Stream<A> stream = this;
        int n = 0;
        while (!stream.isEmpty()) {
            stream = stream.tail()._1();
            ++n;
        }
        return n;
    }

    public final A index(int n) {
        if (n < 0) {
            throw Bottom.error("index " + n + " out of range on stream");
        }
        Stream<A> stream = this;
        for (int i = 0; i < n; ++i) {
            if (stream.isEmpty()) {
                throw Bottom.error("index " + n + " out of range on stream");
            }
            stream = stream.tail()._1();
        }
        if (stream.isEmpty()) {
            throw Bottom.error("index " + n + " out of range on stream");
        }
        return stream.head();
    }

    public static <A> Stream<A> nil() {
        return new Nil();
    }

    public static <A> Stream<A> single(A a) {
        return Stream.cons(a, new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.nil();
            }
        });
    }

    public static <A> Stream<A> cons(A a, P1<Stream<A>> p1) {
        return new Cons<A>(a, p1);
    }

    public static <A> Stream<A> join(Stream<Stream<A>> stream) {
        return Monoid.streamMonoid().sumRight(stream);
    }

    public static <A, B> Stream<A> unfold(final F<B, Option<P2<A, B>>> f, B b) {
        Option<P2<A, B>> option = f.f(b);
        if (option.isNone()) {
            return Stream.nil();
        }
        final P2<A, B> p2 = option.some();
        return Stream.cons(p2._1(), new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.unfold(f, p2._2());
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Cons<A>
    extends Stream<A> {
        private final A head;
        private final P1<Stream<A>> tail;

        Cons(A a, P1<Stream<A>> p1) {
            this.head = a;
            this.tail = p1.memo();
        }

        @Override
        public A head() {
            return this.head;
        }

        @Override
        public P1<Stream<A>> tail() {
            return this.tail;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Nil<A>
    extends Stream<A> {
        private Nil() {
        }

        @Override
        public A head() {
            throw Bottom.error("head on empty stream");
        }

        @Override
        public P1<Stream<A>> tail() {
            throw Bottom.error("tail on empty stream");
        }
    }
}

