/*
 * Decompiled with CFR 0.152.
 */
package fj.function;

import fj.F;
import fj.F2;
import fj.Function;
import fj.Semigroup;

public final class Doubles {
    public static final F<Double, F<Double, Double>> add = Semigroup.doubleAdditionSemigroup.sum();
    public static final F<Double, F<Double, Double>> multiply = Semigroup.doubleMultiplicationSemigroup.sum();
    public static final F<Double, F<Double, Double>> subtract = Function.curry(new F2<Double, Double, Double>(){

        @Override
        public Double f(Double d, Double d2) {
            return d - d2;
        }
    });
    public static final F<Double, Double> negate = new F<Double, Double>(){

        @Override
        public Double f(Double d) {
            return d * -1.0;
        }
    };
    public static final F<Double, Double> abs = new F<Double, Double>(){

        @Override
        public Double f(Double d) {
            return Math.abs(d);
        }
    };
    public static final F<Double, F<Double, Double>> remainder = Function.curry(new F2<Double, Double, Double>(){

        @Override
        public Double f(Double d, Double d2) {
            return d % d2;
        }
    });
    public static final F<Double, F<Double, Double>> power = Function.curry(new F2<Double, Double, Double>(){

        @Override
        public Double f(Double d, Double d2) {
            return StrictMath.pow(d, d2);
        }
    });
    public static final F<Double, Boolean> even = new F<Double, Boolean>(){

        @Override
        public Boolean f(Double d) {
            return d % 2.0 == 0.0;
        }
    };
    public static final F<Double, Boolean> gtZero = new F<Double, Boolean>(){

        @Override
        public Boolean f(Double d) {
            return Double.compare(d, 0.0) > 0;
        }
    };
    public static final F<Double, Boolean> gteZero = new F<Double, Boolean>(){

        @Override
        public Boolean f(Double d) {
            return Double.compare(d, 0.0) >= 0;
        }
    };
    public static final F<Double, Boolean> ltZero = new F<Double, Boolean>(){

        @Override
        public Boolean f(Double d) {
            return Double.compare(d, 0.0) < 0;
        }
    };
    public static final F<Double, Boolean> lteZero = new F<Double, Boolean>(){

        @Override
        public Boolean f(Double d) {
            return Double.compare(d, 0.0) <= 0;
        }
    };
}

