/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.charts;

import edu.colorado.phet.common.motion.charts.MotionSliderNode;
import edu.colorado.phet.common.motion.charts.Range;
import edu.colorado.phet.common.motion.charts.TextBox;
import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.ShadowPText;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.io.IOException;

public class PlayAreaSliderControl
extends PNode {
    private MotionSliderNode slider;
    private TextBox textBox;
    final DefaultDecimalFormat decimalFormat = new DefaultDecimalFormat("0.00");

    public PlayAreaSliderControl(double d, double d2, double d3, String string, String string2, Color color, TextBox textBox) {
        this.textBox = textBox;
        ShadowPText shadowPText = new ShadowPText(string);
        shadowPText.setTextPaint(color);
        shadowPText.setFont(new PhetFont(20, true));
        this.addChild(shadowPText);
        this.addChild(textBox);
        textBox.setOffset(200.0, shadowPText.getFullBounds().getCenterY() - textBox.getFullBounds().getHeight() / 2.0);
        try {
            this.slider = new MotionSliderNode.Horizontal(new Range(d, d2), 0.0, new Range(0.0, 350.0), color);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.addChild(this.slider);
        this.slider.setOffset(0.0, shadowPText.getFullBounds().getHeight() + 10.0);
        HTMLNode hTMLNode = new HTMLNode(string2);
        hTMLNode.setHTMLColor(color);
        hTMLNode.setFont(new PhetFont(20, true));
        this.addChild(hTMLNode);
        hTMLNode.setOffset(textBox.getFullBounds().getMaxX() + 2.0, 0.0);
        this.setValue(d3);
    }

    public void setValue(double d) {
        this.slider.setValue(d);
        this.textBox.setText(this.decimalFormat.format(d));
    }

    public void addListener(MotionSliderNode.Listener listener) {
        this.slider.addListener(listener);
    }

    public void setHighlighted(boolean bl) {
        this.slider.setHighlighted(bl);
    }
}

