/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman;

import bsh.EvalError;
import edu.colorado.phet.common.motion.charts.GoButton;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.movingman.MovingManModule;
import edu.colorado.phet.movingman.MovingManStrings;
import edu.colorado.phet.movingman.model.ExpressionEvaluator;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ExpressionDialog
extends JDialog {
    protected final JTextField expressionTextField;
    private MovingManModule module;
    protected final JLabel errorLabel;
    protected JDialog helpDialog;

    public ExpressionDialog(PhetFrame phetFrame, final MovingManModule movingManModule) {
        super((Frame)phetFrame, MovingManStrings.EXPRESSIONS_TITLE);
        this.module = movingManModule;
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        verticalLayoutPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        verticalLayoutPanel.add(new JLabel(MovingManStrings.EXPRESSIONS_DESCRIPTION));
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel(MovingManStrings.EXPRESSIONS_RANGE + " ="));
        this.expressionTextField = new JTextField("7 * sin(t) + 2", 14);
        this.expressionTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExpressionDialog.this.setExpressionToModule();
            }
        });
        this.expressionTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                ExpressionDialog.this.setExpressionToModule();
            }
        });
        jPanel.add(this.expressionTextField);
        verticalLayoutPanel.add(jPanel);
        PhetPCanvas phetPCanvas = new PhetPCanvas();
        Serializable serializable = new GoButton(movingManModule.recordAndPlaybackModel, new BooleanProperty(true));
        ((PNode)serializable).addInputEventListener(new PBasicInputEventHandler(){

            public void mouseReleased(PInputEvent pInputEvent) {
                movingManModule.getMovingManModel().getMovingMan().setPositionDriven();
                ExpressionDialog.this.setExpressionToModule();
            }
        });
        phetPCanvas.addScreenChild((PNode)serializable);
        Serializable serializable2 = new Dimension((int)((PNode)serializable).getFullBounds().getWidth(), (int)((PNode)serializable).getFullBounds().getHeight());
        phetPCanvas.setPreferredSize((Dimension)serializable2);
        phetPCanvas.setMaximumSize((Dimension)serializable2);
        phetPCanvas.setBorder(null);
        phetPCanvas.setBackground(verticalLayoutPanel.getBackground());
        verticalLayoutPanel.setFillNone();
        verticalLayoutPanel.add(phetPCanvas);
        verticalLayoutPanel.add(Box.createVerticalStrut(40));
        serializable = new JPanel();
        this.errorLabel = new JLabel(MovingManStrings.EXPRESSIONS_ERROR);
        this.errorLabel.setFont(new PhetFont(PhetFont.getDefaultFontSize(), true));
        this.errorLabel.setForeground(Color.red);
        this.errorLabel.setVisible(false);
        serializable2 = new JButton(MovingManStrings.EXPRESSIONS_HELP);
        ((AbstractButton)serializable2).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExpressionDialog.this.showHelp();
            }
        });
        ((Container)serializable).add(this.errorLabel);
        ((Container)serializable).add((Component)serializable2);
        verticalLayoutPanel.add((Component)serializable);
        this.setContentPane(verticalLayoutPanel);
        this.pack();
        this.setLocation((int)(phetFrame.getBounds().getMaxX() - (double)this.getWidth()), (int)(phetFrame.getBounds().getMaxY() - (double)this.getHeight()));
    }

    private void showHelp() {
        if (this.helpDialog == null) {
            this.helpDialog = this.createHelpDialog();
        }
        this.helpDialog.setVisible(true);
    }

    private JDialog createHelpDialog() {
        JDialog jDialog = new JDialog((Dialog)this, MovingManStrings.EXPRESSIONS_HELP);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JEditorPane jEditorPane = new JEditorPane("text/html", MovingManStrings.EXPRESSIONS_EXAMPLES);
        jEditorPane.setEditable(false);
        jPanel.add(jEditorPane);
        jDialog.setContentPane(jPanel);
        jDialog.pack();
        jDialog.setLocation(this.getX(), this.getY() + this.getHeight());
        return jDialog;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.setExpressionToModule();
        } else {
            this.module.setExpression(null);
        }
    }

    private void setExpressionToModule() {
        ExpressionEvaluator expressionEvaluator = new ExpressionEvaluator(this.expressionTextField.getText());
        try {
            expressionEvaluator.evaluate(0.0);
            expressionEvaluator.evaluate(1.0);
            this.errorLabel.setVisible(false);
            this.expressionTextField.setBorder(BorderFactory.createLineBorder(Color.gray));
        }
        catch (EvalError evalError) {
            this.errorLabel.setVisible(true);
            this.expressionTextField.setBorder(BorderFactory.createLineBorder(Color.red));
        }
        this.module.setExpression(expressionEvaluator);
    }
}

