/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.model;

import bsh.EvalError;
import edu.colorado.phet.common.motion.MotionMath;
import edu.colorado.phet.common.motion.charts.ChartCursor;
import edu.colorado.phet.common.motion.charts.Range;
import edu.colorado.phet.common.motion.charts.TemporalDataSeries;
import edu.colorado.phet.common.motion.model.TimeData;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.movingman.model.ExpressionEvaluator;
import edu.colorado.phet.movingman.model.JListener;
import edu.colorado.phet.movingman.model.ManState;
import edu.colorado.phet.movingman.model.MovingMan;
import edu.colorado.phet.movingman.model.MovingManState;
import edu.colorado.phet.movingman.model.ObservableDouble;
import java.util.ArrayList;

public class MovingManModel {
    private MovingMan movingMan;
    private static final int sizeLimit = Math.max(4, 6);
    private TemporalDataSeries mouseDataModelSeries = new TemporalDataSeries.LimitedSize(sizeLimit);
    private TemporalDataSeries positionModelSeries = new TemporalDataSeries.LimitedSize(sizeLimit);
    private TemporalDataSeries velocityModelSeries = new TemporalDataSeries.LimitedSize(sizeLimit);
    private TemporalDataSeries accelerationModelSeries = new TemporalDataSeries.LimitedSize(sizeLimit);
    private TemporalDataSeries positionGraphSeries = new TemporalDataSeries.LimitedTime(20.0);
    private TemporalDataSeries velocityGraphSeries = new TemporalDataSeries.LimitedTime(20.0);
    private TemporalDataSeries accelerationGraphSeries = new TemporalDataSeries.LimitedTime(20.0);
    private ChartCursor chartCursor = new ChartCursor();
    private double time = 0.0;
    private double mousePosition;
    private ArrayList<Listener> listeners = new ArrayList();
    private boolean VELOCITY_VECTOR_VISIBLE_BY_DEFAULT = false;
    private boolean ACCELERATION_VECTOR_VISIBLE_BY_DEFAULT = false;
    private boolean WALLS_BY_DEFAULT = true;
    private BooleanProperty velocityVectorVisible = new BooleanProperty(this.VELOCITY_VECTOR_VISIBLE_BY_DEFAULT);
    private BooleanProperty accelerationVectorVisible = new BooleanProperty(this.ACCELERATION_VECTOR_VISIBLE_BY_DEFAULT);
    private BooleanProperty walls = new BooleanProperty(this.WALLS_BY_DEFAULT);
    protected final Range modelRange;
    private Range range = this.modelRange = new Range(-10.0, 10.0);
    private BooleanGetter isPaused;
    private BooleanProperty positionMode;
    private BooleanProperty accelerationMode;
    private ExpressionEvaluator expressionEvaluator;
    private ArrayList<EvalErrorListener> evalErrorListeners = new ArrayList();
    private BooleanProperty velocityMode;
    private MyObservableDouble timeProperty = new MyObservableDouble(0.0);
    private final ArrayList<Double> times = new ArrayList();
    private ArrayList<JListener> collisionListeners = new ArrayList();

    public void historyRemainderCleared(double d) {
        this.mouseDataModelSeries.clearPointsAfter(d);
        this.positionModelSeries.clearPointsAfter(d);
        this.velocityModelSeries.clearPointsAfter(d);
        this.accelerationModelSeries.clearPointsAfter(d);
        this.positionGraphSeries.clearPointsAfter(d);
        this.velocityGraphSeries.clearPointsAfter(d);
        this.accelerationGraphSeries.clearPointsAfter(d);
    }

    public Range getModelRange() {
        return this.modelRange;
    }

    public BooleanProperty getPositionMode() {
        return this.positionMode;
    }

    public void setExpression(ExpressionEvaluator expressionEvaluator) {
        this.expressionEvaluator = expressionEvaluator;
    }

    public BooleanProperty getAccelerationMode() {
        return this.accelerationMode;
    }

    public BooleanProperty getVelocityMode() {
        return this.velocityMode;
    }

    public ObservableDouble getTimeProperty() {
        return this.timeProperty;
    }

    public MovingManModel(BooleanGetter booleanGetter) {
        this.movingMan = new MovingMan();
        this.isPaused = booleanGetter;
        this.positionMode = new BooleanProperty(false);
        MovingMan.Listener listener = new MovingMan.Listener(){

            public void changed() {
                MovingManModel.this.positionMode.set(MovingManModel.this.getMovingMan().getMotionStrategy() == MovingMan.POSITION_DRIVEN);
            }
        };
        this.getMovingMan().addListener(listener);
        listener.changed();
        this.velocityMode = new BooleanProperty(false);
        listener = new MovingMan.Listener(){

            public void changed() {
                MovingManModel.this.velocityMode.set(MovingManModel.this.getMovingMan().getMotionStrategy() == MovingMan.VELOCITY_DRIVEN);
            }
        };
        this.getMovingMan().addListener(listener);
        listener.changed();
        this.accelerationMode = new BooleanProperty(false);
        listener = new MovingMan.Listener(){

            public void changed() {
                MovingManModel.this.accelerationMode.set(MovingManModel.this.getMovingMan().getMotionStrategy() == MovingMan.ACCELERATION_DRIVEN);
            }
        };
        listener.changed();
        this.getMovingMan().addListener(listener);
    }

    public void resetAll() {
        this.movingMan.resetAll();
        this.walls.set(this.WALLS_BY_DEFAULT);
        this.velocityVectorVisible.set(this.VELOCITY_VECTOR_VISIBLE_BY_DEFAULT);
        this.accelerationVectorVisible.set(this.ACCELERATION_VECTOR_VISIBLE_BY_DEFAULT);
        this.clear();
    }

    public WallResult clampIfWalled(double d) {
        double d2 = this.range.clamp(d);
        if (((Boolean)this.walls.get()).booleanValue()) {
            return new WallResult(d2, d2 != d);
        }
        return new WallResult(d, false);
    }

    public void simulationTimeChanged(double d) {
        this.time += d;
        this.times.add(this.time);
        if (this.times.size() > 10) {
            this.times.remove(0);
        }
        this.updateTimeProperty();
        if (this.movingMan.isPositionDriven()) {
            double d2;
            double d3 = this.movingMan.getPosition();
            if (this.expressionEvaluator == null) {
                this.mouseDataModelSeries.addPoint(this.clampIfWalled((double)this.mousePosition).position, this.time);
                TimeData[] timeDataArray = this.mouseDataModelSeries.getPointsInRange(this.mouseDataModelSeries.getNumPoints() - 4, this.mouseDataModelSeries.getNumPoints());
                double d4 = 0.0;
                for (TimeData timeData : timeDataArray) {
                    d4 += timeData.getValue();
                }
                d2 = this.clampIfWalled((double)(d4 / (double)timeDataArray.length)).position;
                this.positionModelSeries.addPoint(d2, this.time);
            } else {
                double d5 = 0.0;
                try {
                    d5 = this.expressionEvaluator.evaluate(this.time);
                }
                catch (EvalError evalError) {
                    for (EvalErrorListener evalErrorListener : this.evalErrorListeners) {
                        evalErrorListener.errorOccurred(evalError);
                    }
                }
                d2 = this.clampIfWalled((double)d5).position;
                this.setMousePosition(d2);
                this.mouseDataModelSeries.addPoint(d2, this.time);
                this.positionModelSeries.addPoint(d2, this.time);
            }
            this.velocityModelSeries.setData(this.estimateCenteredDerivatives(this.positionModelSeries));
            this.accelerationModelSeries.setData(this.estimateCenteredDerivatives(this.velocityModelSeries));
            double d6 = this.getTimeNTimeStepsAgo(1);
            double d7 = this.getTimeNTimeStepsAgo(2);
            this.positionGraphSeries.addPoint(d2, this.time);
            this.velocityGraphSeries.addPoint(this.getPointAtTime(this.velocityModelSeries, d6, this.time));
            this.accelerationGraphSeries.addPoint(this.getPointAtTime(this.accelerationModelSeries, d7, this.time));
            this.movingMan.setPosition(d2);
            double d8 = this.velocityGraphSeries.getLastPoint().getValue();
            if (Math.abs(d8) < 1.0E-6) {
                d8 = 0.0;
            }
            this.movingMan.setVelocity(d8);
            double d9 = this.accelerationGraphSeries.getLastPoint().getValue();
            if (Math.abs(d9) < 1.0E-6) {
                d9 = 0.0;
            }
            this.movingMan.setAcceleration(d9);
            if (!this.hitsWall(d3) && this.hitsWall(this.movingMan.getPosition())) {
                this.notifyCollided();
            }
        } else if (this.movingMan.isVelocityDriven()) {
            this.mouseDataModelSeries.clear();
            this.velocityModelSeries.addPoint(this.movingMan.getVelocity(), this.time);
            this.velocityGraphSeries.addPoint(this.movingMan.getVelocity(), this.time);
            this.accelerationModelSeries.setData(this.estimateCenteredDerivatives(this.velocityModelSeries));
            this.accelerationGraphSeries.addPoint(this.accelerationModelSeries.getMidPoint());
            double d10 = this.movingMan.getPosition() + this.movingMan.getVelocity() * d;
            WallResult wallResult = this.clampIfWalled(d10);
            this.positionModelSeries.addPoint(wallResult.position, this.time);
            this.positionGraphSeries.addPoint(wallResult.position, this.time);
            this.setMousePosition(wallResult.position);
            this.movingMan.setPosition(wallResult.position);
            double d11 = this.accelerationGraphSeries.getLastPoint().getValue();
            if (Math.abs(d11) < 1.0E-6) {
                d11 = 0.0;
            }
            this.movingMan.setAcceleration(d11);
            if (wallResult.collided) {
                this.movingMan.setVelocity(0.0);
                this.notifyCollided();
            }
        } else if (this.movingMan.isAccelerationDriven()) {
            this.mouseDataModelSeries.clear();
            double d12 = this.movingMan.getVelocity() + this.movingMan.getAcceleration() * d;
            double d13 = (this.movingMan.getVelocity() + d12) / 2.0;
            WallResult wallResult = this.clampIfWalled(this.movingMan.getPosition() + d13 * d);
            if (wallResult.collided) {
                this.movingMan.setVelocityDriven();
                this.movingMan.setVelocity(d12);
                this.time -= d;
                this.simulationTimeChanged(d);
                return;
            }
            this.accelerationModelSeries.addPoint(this.movingMan.getAcceleration(), this.time);
            this.accelerationGraphSeries.addPoint(this.movingMan.getAcceleration(), this.time);
            this.velocityGraphSeries.addPoint(d12, this.time);
            this.velocityModelSeries.addPoint(d12, this.time);
            this.positionGraphSeries.addPoint(wallResult.position, this.time);
            this.positionModelSeries.addPoint(wallResult.position, this.time);
            this.setMousePosition(wallResult.position);
            this.movingMan.setPosition(wallResult.position);
            this.movingMan.setVelocity(d12);
            if (wallResult.collided) {
                this.movingMan.setVelocity(0.0);
                this.movingMan.setAcceleration(0.0);
            }
        }
    }

    private double getTimeNTimeStepsAgo(int n) {
        double d;
        int n2 = this.times.size() - 1 - n;
        if (n2 < 0) {
            n2 = this.times.size() - 1;
        }
        if ((d = this.times.get(n2).doubleValue()) > this.time) {
            throw new RuntimeException("Found a time n steps ago that was later than t=time");
        }
        return d;
    }

    private boolean hitsWall(double d) {
        return this.range.getMax() == d || this.range.getMin() == d;
    }

    public void addCollisionListener(JListener jListener) {
        this.collisionListeners.add(jListener);
    }

    private void notifyCollided() {
        for (JListener jListener : this.collisionListeners) {
            jListener.eventOccurred();
        }
    }

    private TimeData getPointAtTime(TemporalDataSeries temporalDataSeries, double d, double d2) {
        for (int i = 0; i < temporalDataSeries.getNumPoints(); ++i) {
            if (temporalDataSeries.getDataPoint(i).getTime() != d) continue;
            return new TimeData(temporalDataSeries.getDataPoint(i).getValue(), d2);
        }
        throw new RuntimeException("Couldn't find exact match");
    }

    private TimeData[] estimateCenteredDerivatives(TemporalDataSeries temporalDataSeries) {
        int n = 1;
        ArrayList<TimeData> arrayList = new ArrayList<TimeData>();
        for (int i = 0; i < temporalDataSeries.getNumPoints(); ++i) {
            TimeData[] timeDataArray = temporalDataSeries.getPointsInRange(i - n, i + n);
            double d = MotionMath.estimateDerivative(timeDataArray);
            arrayList.add(new TimeData(d, temporalDataSeries.getDataPoint(i).getTime()));
        }
        return arrayList.toArray(new TimeData[arrayList.size()]);
    }

    public MovingMan getMovingMan() {
        return this.movingMan;
    }

    public TemporalDataSeries getPositionGraphSeries() {
        return this.positionGraphSeries;
    }

    public TemporalDataSeries getVelocityGraphSeries() {
        return this.velocityGraphSeries;
    }

    public TemporalDataSeries getAccelerationGraphSeries() {
        return this.accelerationGraphSeries;
    }

    public ChartCursor getChartCursor() {
        return this.chartCursor;
    }

    public void clear() {
        this.time = 0.0;
        this.times.clear();
        this.updateTimeProperty();
        this.setMousePosition(this.movingMan.getPosition());
        this.mouseDataModelSeries.clear();
        this.positionModelSeries.clear();
        this.velocityModelSeries.clear();
        this.accelerationModelSeries.clear();
        this.positionGraphSeries.clear();
        this.velocityGraphSeries.clear();
        this.accelerationGraphSeries.clear();
    }

    public MovingManState getRecordingState() {
        return new MovingManState(this.positionGraphSeries.getLastPoint().getTime(), new ManState(this.positionGraphSeries.getLastPoint().getValue(), this.velocityGraphSeries.getLastPoint().getValue(), this.accelerationGraphSeries.getLastPoint().getValue(), this.movingMan.getMotionStrategy()), (Boolean)this.walls.get());
    }

    public void setPlaybackState(MovingManState movingManState) {
        this.time = movingManState.getTime();
        this.times.clear();
        this.walls.set(movingManState.getWalls());
        this.movingMan.setState(movingManState.getMovingManState());
        this.setMousePosition(movingManState.getMovingManState().getPosition());
        this.chartCursor.setTime(this.time);
        this.updateTimeProperty();
    }

    private void updateTimeProperty() {
        this.timeProperty.setValue(this.time);
    }

    public void setMousePosition(double d) {
        if (this.mousePosition != d) {
            this.mousePosition = this.clampIfWalled((double)d).position;
            if (this.isPaused.isTrue()) {
                this.movingMan.setPosition(d);
            }
            for (Listener listener : this.listeners) {
                listener.mousePositionChanged();
            }
        }
    }

    public double getMousePosition() {
        return this.mousePosition;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public Range getRange() {
        return this.range;
    }

    public BooleanProperty getWalls() {
        return this.walls;
    }

    public BooleanProperty getVelocityVectorVisible() {
        return this.velocityVectorVisible;
    }

    public BooleanProperty getAccelerationVectorVisible() {
        return this.accelerationVectorVisible;
    }

    public static interface BooleanGetter {
        public boolean isTrue();
    }

    public static interface EvalErrorListener {
        public void errorOccurred(EvalError var1);
    }

    public static interface Listener {
        public void mousePositionChanged();
    }

    private class MyObservableDouble
    extends ObservableDouble {
        public MyObservableDouble(double d) {
            super(d);
        }

        public void setValue(double d) {
            super.setValue(d);
        }
    }

    public static class WallResult {
        public final double position;
        public final boolean collided;

        public WallResult(double d, boolean bl) {
            this.position = d;
            this.collided = bl;
        }
    }
}

