/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.recordandplayback.model;

import edu.colorado.phet.common.phetcommon.util.SimpleObservable;
import edu.colorado.phet.recordandplayback.model.DataPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RecordAndPlaybackModel<T>
extends SimpleObservable {
    private final ArrayList<DataPoint<T>> recordHistory = new ArrayList();
    private Mode mode;
    private Record recordMode = new Record();
    private Playback playbackMode = new Playback();
    private Live liveMode = new Live();
    private boolean paused;
    private double time;
    private ArrayList<HistoryClearListener> historyClearListeners = new ArrayList();
    private ArrayList<HistoryRemainderClearListener> historyRemainderClearListeners = new ArrayList();
    private int maxRecordPoints;

    public abstract T step(double var1);

    public abstract void setPlaybackState(T var1);

    protected RecordAndPlaybackModel(int n) {
        this.maxRecordPoints = n;
        this.resetAll();
    }

    public int getMaxRecordPoints() {
        return this.maxRecordPoints;
    }

    protected void handleRecordStartedDuringPlayback() {
    }

    private DataPoint<T> getPlaybackState() {
        ArrayList<DataPoint<T>> arrayList = new ArrayList<DataPoint<T>>(this.recordHistory);
        Collections.sort(arrayList, new Comparator<DataPoint<T>>(){

            @Override
            public int compare(DataPoint<T> dataPoint, DataPoint<T> dataPoint2) {
                return Double.compare(Math.abs(dataPoint.getTime() - RecordAndPlaybackModel.this.time), Math.abs(dataPoint2.getTime() - RecordAndPlaybackModel.this.time));
            }
        });
        return arrayList.get(0);
    }

    public void rewind() {
        this.setTime(this.getMinRecordedTime());
    }

    public void setTime(double d) {
        this.time = d;
        if (this.isPlayback() && this.getNumRecordedPoints() > 0) {
            this.setPlaybackState(this.getPlaybackState().getState());
        }
        this.notifyObservers();
    }

    public void resetAll() {
        this.setPlaybackSpeed(1.0);
        this.clearHistory();
        this.setTime(0.0);
        this.setRecord(true);
        this.setPaused(true);
    }

    public void addRecordedPoint(DataPoint<T> dataPoint) {
        this.recordHistory.add(dataPoint);
        this.notifyObservers();
    }

    public void setPlaybackSpeed(double d) {
        if (d != this.playbackMode.getSpeed()) {
            this.playbackMode.setSpeed(d);
            this.notifyObservers();
        }
    }

    public void setRecord(boolean bl) {
        if (bl && this.mode != this.recordMode) {
            this.mode = this.recordMode;
            this.clearHistoryRemainder();
            this.handleRecordStartedDuringPlayback();
            this.notifyObservers();
        } else if (!bl && this.mode != this.playbackMode) {
            this.mode = this.playbackMode;
            this.notifyObservers();
        }
    }

    public int getNumRecordedPoints() {
        return this.recordHistory.size();
    }

    public void clearHistoryRemainder() {
        ArrayList<DataPoint<T>> arrayList = new ArrayList<DataPoint<T>>();
        for (DataPoint<T> dataPoint : this.recordHistory) {
            if (!(dataPoint.getTime() < this.time)) continue;
            arrayList.add(dataPoint);
        }
        this.recordHistory.clear();
        this.recordHistory.addAll(arrayList);
        this.notifyObservers();
        for (HistoryRemainderClearListener historyRemainderClearListener : this.historyRemainderClearListeners) {
            historyRemainderClearListener.historyRemainderCleared();
        }
    }

    public void addHistoryRemainderClearListener(HistoryRemainderClearListener historyRemainderClearListener) {
        this.historyRemainderClearListeners.add(historyRemainderClearListener);
    }

    private double getPlaybackDT() {
        if (this.getNumRecordedPoints() == 0) {
            return 0.0;
        }
        if (this.getNumRecordedPoints() == 1) {
            return this.recordHistory.get(0).getTime();
        }
        return (this.recordHistory.get(this.recordHistory.size() - 1).getTime() - this.recordHistory.get(0).getTime()) / (double)this.recordHistory.size();
    }

    public void addHistoryClearListener(HistoryClearListener historyClearListener) {
        this.historyClearListeners.add(historyClearListener);
    }

    public void clearHistory() {
        this.recordHistory.clear();
        this.setTime(0.0);
        this.notifyObservers();
        for (HistoryClearListener historyClearListener : this.historyClearListeners) {
            historyClearListener.historyCleared();
        }
    }

    public boolean isPlayback() {
        return this.mode == this.playbackMode;
    }

    public boolean isRecord() {
        return this.mode == this.recordMode;
    }

    public void setPaused(boolean bl) {
        if (this.paused != bl) {
            this.paused = bl;
            this.notifyObservers();
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isRecordingFull() {
        return this.recordHistory.size() >= this.getMaxRecordPoints();
    }

    public double getRecordedTimeRange() {
        if (this.recordHistory.size() == 0) {
            return 0.0;
        }
        return this.recordHistory.get(this.recordHistory.size() - 1).getTime() - this.recordHistory.get(0).getTime();
    }

    public double getTime() {
        return this.time;
    }

    public double getMaxRecordedTime() {
        if (this.recordHistory.size() == 0) {
            return 0.0;
        }
        return this.recordHistory.get(this.recordHistory.size() - 1).getTime();
    }

    public double getMinRecordedTime() {
        if (this.recordHistory.size() == 0) {
            return 0.0;
        }
        return this.recordHistory.get(0).getTime();
    }

    public double getPlaybackSpeed() {
        return this.playbackMode.getSpeed();
    }

    public void startRecording() {
        this.setModeRecord();
        this.setPaused(false);
    }

    public void stepInTime(double d) {
        if (!this.isPaused()) {
            this.stepMode(d);
        }
    }

    protected void stepMode(double d) {
        this.mode.step(d);
    }

    public void step() {
        this.stepMode(this.getPlaybackDT());
    }

    protected void setMode(Mode mode) {
        this.mode = mode;
        this.notifyObservers();
    }

    public void setModeRecord() {
        this.setMode(this.recordMode);
    }

    public static interface HistoryClearListener {
        public void historyCleared();
    }

    public static interface HistoryRemainderClearListener {
        public void historyRemainderCleared();
    }

    public class Live
    implements Mode {
        public void step(double d) {
            RecordAndPlaybackModel.this.setTime(RecordAndPlaybackModel.this.getTime() + d);
            RecordAndPlaybackModel.this.step(d);
        }

        public String toString() {
            return "Live";
        }
    }

    public static interface Mode {
        public void step(double var1);
    }

    public class Playback
    implements Mode {
        private double speed;

        public void setSpeed(double d) {
            this.speed = d;
        }

        public double getSpeed() {
            return this.speed;
        }

        public void step(double d) {
            if (this.speed > 0.0) {
                if (RecordAndPlaybackModel.this.getTime() < RecordAndPlaybackModel.this.getMaxRecordedTime()) {
                    RecordAndPlaybackModel.this.setTime(RecordAndPlaybackModel.this.time + this.speed * RecordAndPlaybackModel.this.getPlaybackDT());
                    RecordAndPlaybackModel.this.notifyObservers();
                } else {
                    RecordAndPlaybackModel.this.setPaused(true);
                }
            } else if (this.speed < 0.0 && RecordAndPlaybackModel.this.getTime() > RecordAndPlaybackModel.this.getMinRecordedTime()) {
                RecordAndPlaybackModel.this.setTime(RecordAndPlaybackModel.this.time + this.speed * RecordAndPlaybackModel.this.getPlaybackDT());
                RecordAndPlaybackModel.this.notifyObservers();
            }
        }

        public String toString() {
            return "Playback";
        }
    }

    public class Record
    implements Mode {
        public void step(double d) {
            RecordAndPlaybackModel.this.setTime(RecordAndPlaybackModel.this.getTime() + d);
            Object t = RecordAndPlaybackModel.this.step(d);
            RecordAndPlaybackModel.this.addRecordedPoint(new DataPoint(RecordAndPlaybackModel.this.getTime(), t));
        }

        public String toString() {
            return "Record";
        }
    }
}

