/*
 * Decompiled with CFR 0.152.
 */
package oscila6;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import oscila6.OscilaApplet6;

public class MiCanvas
extends Canvas {
    OscilaApplet6 parent;
    int cAncho;
    int cAlto;
    int wAncho;
    int wAlto;
    int orgX;
    int orgY;
    int orgXRegla;
    int orgXEnergia;
    int orgYEnergia;
    double escEnergia;
    double escala;
    double escTiempo;
    double escFuerza;
    final double G = 9.8;
    double masaBloque = 10.0;
    double yBloque;
    final double longitudMuelle = 0.5;
    double cteMuelle = 1000.0;
    int[] xMuelle = new int[23];
    int[] yMuelle = new int[23];
    double dx = 0.0;
    double yEquilibrio;
    double t = 0.0;
    double dt = 0.005;
    final double tMax = 5.0;
    double w0;
    Polygon poli = null;
    boolean bMover = false;
    Image imag;
    Graphics gBuffer;
    Dimension dim;

    public MiCanvas(OscilaApplet6 p) {
        this.parent = p;
        this.setBackground(Color.white);
    }

    void origenEscalas(Graphics g) {
        this.wAncho = this.getSize().width;
        this.wAlto = this.getSize().height;
        this.cAlto = g.getFontMetrics().getHeight();
        this.cAncho = g.getFontMetrics().stringWidth("0");
        this.escTiempo = (double)(this.wAncho - this.orgXRegla - 8 * this.cAlto) / 5.0;
        this.orgX = 4 * this.cAlto;
        this.orgY = this.wAlto / 4;
        this.orgXRegla = this.orgX + 4 * this.cAlto + 3 * this.cAncho;
        this.orgXEnergia = this.wAncho - 7 * this.cAlto;
        this.orgYEnergia = this.wAlto / 2;
        this.escala = (double)(this.wAlto - this.cAncho - this.orgY) / 50.0;
    }

    void setInicio() {
        this.dx = 0.0;
        this.escFuerza = (double)(2 * this.cAlto) / (this.masaBloque * 9.8);
        this.bMover = false;
        this.repaint();
    }

    boolean verificaDatos(double cteMuelle, double masaBloque) {
        this.cteMuelle = cteMuelle;
        this.masaBloque = masaBloque;
        this.yEquilibrio = masaBloque * 9.8 / cteMuelle;
        return !((double)2 * this.yEquilibrio > 0.5);
    }

    void setSoltar() {
        this.t = 0.0;
        this.w0 = Math.sqrt(this.cteMuelle / this.masaBloque);
        this.yEquilibrio = this.masaBloque * 9.8 / this.cteMuelle;
        this.orgYEnergia = this.orgY + (int)(this.escala * this.yEquilibrio * (double)100);
        this.escEnergia = (double)(this.orgYEnergia - this.cAncho) / (this.masaBloque * 9.8 * (double)2 * this.yEquilibrio);
        this.poli = new Polygon();
        this.bMover = true;
        this.repaint();
    }

    void mover() {
        this.yBloque = this.yEquilibrio - this.yEquilibrio * Math.sin(this.w0 * this.t + 1.5707963267948966);
        this.dx = this.yBloque * (double)100;
        this.t += this.dt;
        this.repaint();
    }

    void dibujaSistema(Graphics g) {
        g.setColor(Color.black);
        int yExtremo = this.orgY + (int)(this.escala * this.dx);
        double unidad = (double)(this.wAlto - this.cAncho - yExtremo) / (double)20;
        this.yMuelle[0] = yExtremo;
        this.xMuelle[0] = this.orgX;
        this.xMuelle[1] = this.xMuelle[0] + -1 * (3 * this.cAncho - (int)((double)this.cAncho * this.dx / (double)100));
        this.yMuelle[1] = this.yMuelle[0] + (int)(unidad / (double)2);
        for (int i = 2; i < 21; ++i) {
            this.yMuelle[i] = this.yMuelle[1] + (int)((double)(i - 1) * unidad);
            int sgn = i % 2 == 0 ? 1 : -1;
            this.xMuelle[i] = this.xMuelle[0] + sgn * (3 * this.cAncho - (int)((double)this.cAncho * this.dx / (double)100));
        }
        this.xMuelle[21] = this.xMuelle[0];
        this.yMuelle[21] = this.yMuelle[20] + (int)(unidad / (double)2);
        this.xMuelle[22] = this.xMuelle[0];
        this.yMuelle[22] = this.wAlto - this.cAncho;
        g.drawPolyline(this.xMuelle, this.yMuelle, 23);
        g.setColor(Color.black);
        g.fillRect(0, this.wAlto - this.cAncho, this.orgXRegla, this.cAncho);
        g.fillRect(this.xMuelle[0] - 3 * this.cAlto, yExtremo - 2, 6 * this.cAlto, 2);
        if (this.bMover) {
            g.setColor(Color.red);
            g.fillRect(this.orgX - this.cAlto, yExtremo - 2 - this.cAncho, 2 * this.cAlto, this.cAncho);
            g.setColor(Color.black);
            g.drawLine(this.orgX + 2 * this.cAlto, yExtremo, this.orgXRegla - this.cAncho, yExtremo);
            int longitud = (int)(this.masaBloque * 9.8 * this.escFuerza);
            this.dibujaFlecha(g, longitud, -1.5707963267948966, Color.red, this.orgX - 2 * this.cAlto - this.cAncho, yExtremo);
            longitud = (int)(this.cteMuelle * this.yBloque * this.escFuerza);
            this.dibujaFlecha(g, longitud, 1.5707963267948966, Color.blue, this.orgX - 2 * this.cAlto - this.cAncho, yExtremo);
            this.leyendas(g);
            this.graficaOscilacion(g);
            this.energias(g);
        }
    }

    void reglasVerticales(Graphics g) {
        g.setColor(Color.black);
        g.drawLine(this.orgXRegla, 0, this.orgXRegla, this.wAlto);
        g.drawString("cm", this.orgXRegla + this.cAncho, this.cAlto);
        for (int i = -100; i < 100; i += 10) {
            int y2 = this.orgY - (int)(this.escala * (double)i);
            if (y2 < 0 || y2 > this.wAlto) continue;
            g.drawLine(this.orgXRegla, y2, this.orgXRegla - this.cAncho, y2);
            String texto = String.valueOf(i);
            g.drawString(String.valueOf(i), this.orgXRegla - 3 * this.cAncho / 2 - g.getFontMetrics().stringWidth(texto), y2 + this.cAlto / 4);
            for (int j = 1; j < 5; ++j) {
                y2 = this.orgY - (int)(this.escala * (double)(i + 2 * j));
                g.drawLine(this.orgXRegla, y2, this.orgXRegla - this.cAncho / 2, y2);
            }
        }
    }

    void leyendas(Graphics g) {
        g.setColor(Color.black);
        g.drawString("Vectores:", this.cAncho, this.cAlto);
        g.setColor(Color.red);
        g.fillRect(this.cAncho, this.cAlto + this.cAlto / 2, this.cAncho, this.cAlto / 4);
        g.setColor(Color.black);
        g.drawString("Peso", this.cAlto, 2 * this.cAlto);
        g.setColor(Color.blue);
        g.fillRect(this.cAncho, 2 * this.cAlto + this.cAlto / 2, this.cAncho, this.cAlto / 4);
        g.setColor(Color.black);
        g.drawString("Fuerza del muelle", this.cAlto, 3 * this.cAlto);
    }

    void graficaOscilacion(Graphics g) {
        int x1;
        g.setColor(Color.black);
        int y1 = this.orgY + (int)(this.escala * this.yEquilibrio * (double)100);
        g.drawString("t(s)", this.orgXEnergia - 3 * this.cAncho, y1 - this.cAncho / 2);
        for (int i = 0; i <= 5; ++i) {
            x1 = this.orgXRegla + (int)((double)i * this.escTiempo);
            g.drawLine(x1, y1, x1, y1 + this.cAncho);
            String texto = String.valueOf(i);
            g.drawString(texto, x1 - g.getFontMetrics().stringWidth(texto) / 2, y1 + this.cAncho + this.cAlto);
            for (int j = 1; j < 5; ++j) {
                x1 = this.orgXRegla + (int)(((double)i + (double)j / (double)5) * this.escTiempo);
                g.drawLine(x1, y1, x1, y1 + this.cAncho / 2);
            }
        }
        g.drawLine(this.orgXRegla, y1, this.wAncho, y1);
        x1 = this.orgXRegla + (int)(this.escTiempo * this.t);
        y1 = this.orgY + (int)(this.escala * this.yBloque * (double)100);
        int x2 = this.orgXRegla + (int)(this.escTiempo * 5.0);
        double resto = this.t;
        if (x1 < x2) {
            this.poli.addPoint(x1, y1);
        } else {
            int nPeriodos = (int)(5.0 * this.w0 / (Math.PI * 2)) + 1;
            resto = this.t % ((double)(nPeriodos * 2) * Math.PI / this.w0);
            x1 = this.orgXRegla + (int)(this.escTiempo * resto);
        }
        g.setColor(Color.blue);
        g.fillOval(x1 - 2, y1 - 2, 4, 4);
        g.setColor(Color.red);
        g.drawPolyline(this.poli.xpoints, this.poli.ypoints, this.poli.npoints);
    }

    void energias(Graphics g) {
        double ePotBloque = this.masaBloque * 9.8 * (-this.yBloque + this.yEquilibrio);
        double v = this.w0 * this.yEquilibrio * Math.cos(this.w0 * (this.t - this.dt) + 1.5707963267948966);
        double eCinBloque = this.masaBloque * v * v / (double)2;
        int y1 = this.orgYEnergia - (int)(this.escEnergia * ePotBloque);
        g.setColor(Color.blue);
        if (ePotBloque > 0.0) {
            g.fillRect(this.orgXEnergia, y1, 2 * this.cAlto, this.orgYEnergia - y1);
        } else {
            g.fillRect(this.orgXEnergia, this.orgYEnergia, 2 * this.cAlto, -this.orgYEnergia + y1);
        }
        g.setColor(Color.red);
        y1 = this.orgYEnergia - (int)(this.escEnergia * eCinBloque);
        g.fillRect(this.orgXEnergia + 2 * this.cAlto, y1, 2 * this.cAlto, this.orgYEnergia - y1);
        double eElasMuelle = this.cteMuelle * this.yBloque * this.yBloque / (double)2;
        y1 = this.orgYEnergia - (int)(this.escEnergia * eElasMuelle);
        g.setColor(Color.green);
        g.fillRect(this.orgXEnergia + 4 * this.cAlto, y1, 2 * this.cAlto, this.orgYEnergia - y1);
        g.setColor(Color.green);
        g.fillRect(this.orgXRegla + 8 * this.cAlto, this.wAlto - 7 * this.cAlto / 2, this.cAncho, this.cAlto / 4);
        g.setColor(Color.black);
        g.drawString("Energ\u00eda potencial el\u00e1stica", this.orgXRegla + 8 * this.cAlto + 2 * this.cAncho, this.wAlto - 3 * this.cAlto);
        g.setColor(Color.blue);
        g.fillRect(this.orgXRegla + 8 * this.cAlto, this.wAlto - 5 * this.cAlto / 2, this.cAncho, this.cAlto / 4);
        g.setColor(Color.black);
        g.drawString("Energ\u00eda potencial", this.orgXRegla + 8 * this.cAlto + 2 * this.cAncho, this.wAlto - 2 * this.cAlto);
        g.setColor(Color.red);
        g.fillRect(this.orgXRegla + 8 * this.cAlto, this.wAlto - 3 * this.cAlto / 2, this.cAncho, this.cAlto / 4);
        g.setColor(Color.black);
        g.drawString("Energ\u00eda cin\u00e9tica", this.orgXRegla + 8 * this.cAlto + 2 * this.cAncho, this.wAlto - this.cAlto);
        String texto = String.valueOf((double)Math.round((ePotBloque + eCinBloque + eElasMuelle) * (double)10) / (double)10);
        g.drawString(String.valueOf("Energ\u00eda total (J)= ").concat(String.valueOf(texto)), this.wAncho / 2, this.cAlto);
    }

    void dispositivo(Graphics g) {
        this.dibujaSistema(g);
        this.reglasVerticales(g);
    }

    void dibujaFlecha(Graphics g, int lon, double fi, Color c, int x1, int y1) {
        int cap = g.getFontMetrics().getHeight() / 2;
        if (lon < 1) {
            return;
        }
        int x2 = x1 + (int)((double)lon * Math.cos(fi));
        int y2 = y1 - (int)((double)lon * Math.sin(fi));
        g.setColor(c);
        g.drawLine(x1, y1, x2, y2);
        int x3 = x2 - (int)((double)cap * Math.cos(fi - 0.5235987755982988));
        int y3 = y2 + (int)((double)cap * Math.sin(fi - 0.5235987755982988));
        g.drawLine(x2, y2, x3, y3);
        x3 = x2 - (int)((double)cap * Math.sin(-fi + 1.0471975511965976));
        y3 = y2 + (int)((double)cap * Math.cos(-fi + 1.0471975511965976));
        g.drawLine(x2, y2, x3, y3);
    }

    public void paint(Graphics g) {
        this.origenEscalas(g);
        this.dispositivo(g);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.gBuffer == null || d.width != this.dim.width || d.height != this.dim.height) {
            this.dim = d;
            this.imag = this.createImage(d.width, d.height);
            this.gBuffer = this.imag.getGraphics();
        }
        this.gBuffer.setColor(this.getBackground());
        this.gBuffer.fillRect(0, 0, d.width, d.height);
        this.dispositivo(this.gBuffer);
        g.drawImage(this.imag, 0, 0, null);
    }

    void mensaje() {
        Graphics g = this.getGraphics();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.wAncho, this.wAlto);
        g.setColor(Color.black);
        Font oldFont = this.getFont();
        Font fuente = new Font("Times", 1, 16);
        g.setFont(fuente);
        int alto = g.getFontMetrics().getHeight();
        String texto = "Modificar los valores introducidos";
        int ancho = g.getFontMetrics().stringWidth(texto);
        g.drawString(texto, this.wAncho / 2 - ancho / 2, this.wAlto / 2 + alto / 4 - alto);
        g.setFont(oldFont);
        g.dispose();
    }
}

